/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.dimension.renderer;

import earth.terrarium.ad_astra.client.dimension.renderer.ModSkyRenderer;
import earth.terrarium.ad_astra.client.dimension.renderer.ModWeatherRenderer;
import earth.terrarium.ad_astra.client.dimension.renderer.VenusCloudRenderer;
import earth.terrarium.ad_astra.client.dimension.renderer.base.DimensionRenderer;
import earth.terrarium.ad_astra.client.resourcepack.PlanetSkyRenderer;
import earth.terrarium.ad_astra.common.util.ColourUtils;
import net.minecraft.class_1159;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5294;
import net.minecraft.class_638;
import net.minecraft.class_765;

public class DimensionEffects
extends class_5294
implements DimensionRenderer {
    private final PlanetSkyRenderer renderer;
    private final ModSkyRenderer skyRenderer;

    public DimensionEffects(PlanetSkyRenderer renderer) {
        super(192.0f, true, class_5294.class_5401.field_25640, false, false);
        this.renderer = renderer;
        this.skyRenderer = new ModSkyRenderer(renderer);
    }

    public class_243 method_28112(class_243 color, float sunHeight) {
        if (this.renderer.effects().type().equals((Object)PlanetSkyRenderer.DimensionEffectType.COLORED_HORIZON)) {
            return ColourUtils.toVector(this.renderer.effects().colour());
        }
        return color.method_18805((double)(sunHeight * 0.94f + 0.06f), (double)(sunHeight * 0.94f + 0.06f), (double)(sunHeight * 0.91f + 0.09f));
    }

    public boolean method_28110(int camX, int camY) {
        return this.renderer.effects().type().isFoggy();
    }

    public float[] method_28109(float skyAngle, float tickDelta) {
        PlanetSkyRenderer.DimensionEffectType type = this.renderer.effects().type();
        if (type == PlanetSkyRenderer.DimensionEffectType.FOGGY_REVERSED || type == PlanetSkyRenderer.DimensionEffectType.NONE) {
            return null;
        }
        return super.method_28109(skyAngle, tickDelta);
    }

    @Override
    public boolean renderClouds(class_638 level, int ticks, float tickDelta, class_4587 poseStack, double cameraX, double cameraY, double cameraZ, class_1159 projectionMatrix) {
        return switch (this.renderer.cloudEffects()) {
            default -> throw new IncompatibleClassChangeError();
            case PlanetSkyRenderer.CloudEffects.NONE -> true;
            case PlanetSkyRenderer.CloudEffects.VANILLA -> false;
            case PlanetSkyRenderer.CloudEffects.VENUS -> {
                VenusCloudRenderer.render(level, ticks, tickDelta, poseStack, cameraX, cameraY, cameraZ, projectionMatrix);
                yield true;
            }
        };
    }

    @Override
    public boolean shouldRenderClouds() {
        return this.renderer.cloudEffects() != PlanetSkyRenderer.CloudEffects.VANILLA;
    }

    @Override
    public boolean renderSky(class_638 level, int ticks, float tickDelta, class_4587 poseStack, class_4184 camera, class_1159 projectionMatrix, boolean foggy, Runnable setupFog) {
        setupFog.run();
        this.skyRenderer.render(level, ticks, tickDelta, poseStack, camera, projectionMatrix, foggy);
        return true;
    }

    @Override
    public boolean shouldRenderSky() {
        return true;
    }

    @Override
    public boolean renderSnowAndRain(class_638 level, int ticks, float tickDelta, class_765 manager, double cameraX, double cameraY, double cameraZ) {
        return switch (this.renderer.weatherEffects()) {
            default -> throw new IncompatibleClassChangeError();
            case PlanetSkyRenderer.WeatherEffects.NONE -> true;
            case PlanetSkyRenderer.WeatherEffects.VANILLA -> false;
            case PlanetSkyRenderer.WeatherEffects.VENUS -> {
                ModWeatherRenderer.render(level, ticks, tickDelta, manager, cameraX, cameraY, cameraZ);
                yield true;
            }
        };
    }

    @Override
    public boolean shouldRenderSnowAndRain() {
        return this.renderer.weatherEffects() != PlanetSkyRenderer.WeatherEffects.VANILLA;
    }
}

