/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.dimension.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.ad_astra.client.dimension.renderer.SkyUtil;
import earth.terrarium.ad_astra.client.resourcepack.PlanetSkyRenderer;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5365;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;

@Environment(value=EnvType.CLIENT)
public class ModSkyRenderer {
    private final PlanetSkyRenderer.StarsRenderer starsRenderer;
    private final PlanetSkyRenderer.SunsetColour sunsetColour;
    private final List<PlanetSkyRenderer.SkyObject> skyObjects;
    private final int horizonAngle;
    private final boolean shouldRenderWhileRaining;
    private class_291 starsBuffer;
    private int starsCount;

    public ModSkyRenderer(PlanetSkyRenderer skyRenderer) {
        this.starsRenderer = skyRenderer.starsRenderer();
        this.sunsetColour = skyRenderer.sunsetColour();
        this.skyObjects = skyRenderer.skyObjects();
        this.horizonAngle = skyRenderer.horizonAngle();
        this.shouldRenderWhileRaining = !skyRenderer.weatherEffects().equals((Object)PlanetSkyRenderer.WeatherEffects.NONE);
    }

    public void render(class_638 level, int ticks, float tickDelta, class_4587 poseStack, class_4184 camera, class_1159 projectionMatrix, boolean foggy) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        class_310 minecraft = class_310.method_1551();
        if (this.shouldRenderWhileRaining && level.method_8419()) {
            return;
        }
        if (SkyUtil.isSubmerged(camera)) {
            return;
        }
        SkyUtil.preRender(level, minecraft.field_1769, camera, projectionMatrix, bufferBuilder, this.sunsetColour, this.horizonAngle, poseStack, tickDelta);
        if (this.starsRenderer.fastStars() > 0) {
            int stars = !((class_5365)minecraft.field_1690.method_42534().method_41753()).equals((Object)class_5365.field_25427) ? this.starsRenderer.fancyStars() : this.starsRenderer.fastStars();
            this.starsBuffer = this.renderStars(level, poseStack, tickDelta, bufferBuilder, stars, this.starsRenderer, projectionMatrix);
        }
        for (PlanetSkyRenderer.SkyObject skyObject : this.skyObjects) {
            float scale = skyObject.scale();
            class_1160 rotation = skyObject.rotation();
            switch (skyObject.renderType()) {
                case STATIC: {
                    break;
                }
                case DYNAMIC: {
                    rotation = new class_1160(level.method_30274(tickDelta) * 360.0f + rotation.method_4943(), rotation.method_4945(), rotation.method_4947());
                    break;
                }
                case SCALING: {
                    scale *= SkyUtil.getScale();
                    break;
                }
                case DEBUG: {
                    rotation = new class_1160(60.0f, 0.0f, 0.0f);
                }
            }
            SkyUtil.render(poseStack, bufferBuilder, skyObject.texture(), skyObject.colour(), rotation, scale, skyObject.blending());
        }
        SkyUtil.postRender(minecraft.field_1773, level, tickDelta);
    }

    private class_291 renderStars(class_638 level, class_4587 poseStack, float tickDelta, class_287 bufferBuilder, int stars, PlanetSkyRenderer.StarsRenderer starsRenderer, class_1159 projectionMatrix) {
        SkyUtil.startRendering(poseStack, new class_1160(-30.0f, 0.0f, level.method_30274(tickDelta) * 360.0f));
        RenderSystem.setShader(class_757::method_34540);
        this.createStarBuffer(bufferBuilder, stars);
        if (!starsRenderer.daylightVisible()) {
            float rot = level.method_23787(tickDelta);
            RenderSystem.setShaderColor((float)rot, (float)rot, (float)rot, (float)rot);
        } else {
            RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)0.8f);
        }
        class_758.method_23792();
        this.starsBuffer.method_1353();
        this.starsBuffer.method_34427(poseStack.method_23760().method_23761(), projectionMatrix, class_757.method_34540());
        class_291.method_1354();
        poseStack.method_22909();
        return this.starsBuffer;
    }

    private void createStarBuffer(class_287 bufferBuilder, int stars) {
        if (this.starsBuffer != null) {
            if (this.starsCount == stars) {
                return;
            }
            this.starsBuffer.close();
        }
        this.starsBuffer = new class_291();
        this.starsCount = stars;
        class_287.class_7433 renderedBuffer = SkyUtil.renderStars(bufferBuilder, stars, this.starsRenderer.colouredStars());
        this.starsBuffer.method_1353();
        this.starsBuffer.method_1352(renderedBuffer);
        class_291.method_1354();
    }
}

