/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine;

import com.teamresourceful.resourcefullib.common.caches.CacheableFunction;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.block.machine.entity.FluidMachineBlockEntity;
import earth.terrarium.ad_astra.common.block.machine.entity.OxygenDistributorBlockEntity;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.energy.PlatformEnergyManager;
import earth.terrarium.botarium.api.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.api.menu.MenuHooks;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_6328;

@class_6328
public abstract class AbstractMachineBlock
extends class_2237 {
    private static final CacheableFunction<class_2248, class_2591<?>> BLOCK_TO_ENTITY = new CacheableFunction(block -> ModBlockEntityTypes.BLOCK_ENTITY_TYPES.getEntries().stream().map(RegistryEntry::get).filter(type -> type.method_20526(block.method_9564())).findFirst().orElse(null));
    private class_2591<?> entity;
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2746 POWERED = class_2741.field_12484;

    public AbstractMachineBlock(class_4970.class_2251 properties) {
        super(properties.method_9631(AbstractMachineBlock.getLuminance()));
        this.method_9590(this.buildDefaultState());
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (this.entity == null) {
            this.entity = (class_2591)BLOCK_TO_ENTITY.apply((Object)state.method_26204());
        }
        return this.entity.method_11032(pos, state);
    }

    private static ToIntFunction<class_2680> getLuminance() {
        return blockState -> blockState.method_28498((class_2769)LIT) ? (((Boolean)blockState.method_11654((class_2769)LIT)).booleanValue() ? ((AbstractMachineBlock)blockState.method_26204()).getBrightness() : 0) : 0;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return (entityWorld, pos, entityState, blockEntity) -> {
            if (blockEntity instanceof AbstractMachineBlockEntity) {
                AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)blockEntity;
                machine.tick();
            }
        };
    }

    protected class_2680 buildDefaultState() {
        class_2680 state = (class_2680)this.field_10647.method_11664();
        state = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false));
        if (this.useFacing()) {
            state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)class_2350.field_11043);
        }
        if (this.useLit()) {
            state = (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    protected boolean useFacing() {
        return false;
    }

    protected boolean useLit() {
        return false;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862;
        class_1799 item = player.method_5998(hand);
        if (item.method_31573(ModTags.WRENCHES) && this.useFacing()) {
            level.method_8652(pos, this.method_9598(state, class_2470.field_11463), 3);
            return class_1269.field_5812;
        }
        if (!level.field_9236 && (class_25862 = level.method_8321(pos)) instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machineBlock = (AbstractMachineBlockEntity)class_25862;
            MenuHooks.openMenu((class_3222)((class_3222)player), (ExtraDataMenuProvider)machineBlock);
        }
        return class_1269.field_5812;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (this.useFacing()) {
            return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
        }
        return state;
    }

    public int getBrightness() {
        return 12;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            AbstractMachineBlockEntity machineBlock;
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof AbstractMachineBlockEntity && (machineBlock = (AbstractMachineBlockEntity)blockEntity).getInventorySize() > 0) {
                if (this.removeOutput()) {
                    machineBlock.method_5441(machineBlock.getInventorySize() - 1);
                }
                class_1264.method_5451((class_1937)level, (class_2338)pos, (class_1263)machineBlock);
                level.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, level, pos, newState, moved);
        }
    }

    public boolean removeOutput() {
        return false;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_3619 method_9527(class_2680 state) {
        return class_3619.field_15972;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        if (this.useFacing()) {
            builder.method_11667(new class_2769[]{FACING});
        }
        builder.method_11667(new class_2769[]{POWERED});
        if (this.useLit()) {
            builder.method_11667(new class_2769[]{LIT});
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false));
        return this.useFacing() ? (class_2680)state.method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153()) : state;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public boolean doRedstoneCheck() {
        return true;
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        super.method_9612(state, level, pos, block, fromPos, notify);
        if (this.doRedstoneCheck() && !level.field_9236) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(level.method_8479(pos))));
        }
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        return blockEntity instanceof AbstractMachineBlockEntity ? class_1703.method_7608((class_2586)blockEntity) : 0;
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(level, pos, state);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machineBlock = (AbstractMachineBlockEntity)class_25862;
            class_2487 tag = stack.method_7948();
            class_1262.method_5426((class_2487)tag, machineBlock.getItems());
            Optional platformEnergyManager = EnergyHooks.safeGetBlockEnergyManager((class_2586)machineBlock, null);
            platformEnergyManager.ifPresent(energyManager -> tag.method_10544("Energy", ((PlatformEnergyManager)platformEnergyManager.get()).getStoredEnergy()));
            if (machineBlock instanceof FluidMachineBlockEntity) {
                FluidMachineBlockEntity fluidMachine = (FluidMachineBlockEntity)machineBlock;
                tag.method_10566("InputFluid", (class_2520)fluidMachine.getInputTank().serialize());
                tag.method_10566("OutputFluid", (class_2520)fluidMachine.getOutputTank().serialize());
                if (machineBlock instanceof OxygenDistributorBlockEntity) {
                    OxygenDistributorBlockEntity oxygenDistributorMachine = (OxygenDistributorBlockEntity)machineBlock;
                    tag.method_10556("ShowOxygen", oxygenDistributorMachine.shouldShowOxygen());
                }
            }
        }
        return stack;
    }
}

