/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.entity.FluidMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.FuelRefineryConfig;
import earth.terrarium.ad_astra.common.recipe.FuelConversionRecipe;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.screen.menu.ConversionMenu;
import earth.terrarium.ad_astra.common.util.FluidUtils;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuelRefineryBlockEntity
extends FluidMachineBlockEntity
implements EnergyBlock {
    public FuelRefineryBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntityTypes.FUEL_REFINERY.get(), blockPos, blockState);
    }

    @Override
    public long getInputTankCapacity() {
        return FuelRefineryConfig.tankSize;
    }

    @Override
    public long getOutputTankCapacity() {
        return FuelRefineryConfig.tankSize;
    }

    @Override
    public Predicate<FluidHolder> getInputFilter() {
        return f -> FuelConversionRecipe.getRecipes(this.method_10997()).stream().anyMatch(r -> r.matches(f.getFluid()));
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return slot == 0;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 1 || slot == 3;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, @NotNull class_1661 inv, @NotNull class_1657 player) {
        return new ConversionMenu(syncId, inv, this);
    }

    @Override
    public void tick() {
        if (!this.field_11863.method_8608()) {
            class_1799 insertSlot = (class_1799)this.getItems().get(0);
            class_1799 extractSlot = (class_1799)this.getItems().get(1);
            class_1799 outputInsertSlot = (class_1799)this.getItems().get(2);
            class_1799 outputExtractSlot = (class_1799)this.getItems().get(3);
            if (!insertSlot.method_7960() && extractSlot.method_7947() < extractSlot.method_7914() && FluidHooks.isFluidContainingItem((class_1799)insertSlot)) {
                FluidUtils.insertItemFluidToTank(this.getFluidContainer().getInput(), this, 0, 1, 0, f -> FuelConversionRecipe.getRecipes(this.field_11863).stream().anyMatch(r -> r.matches((class_3611)f)));
                FluidUtils.extractTankFluidToItem(this.getFluidContainer().getInput(), this, 0, 1, 0, f -> true);
            }
            if (!outputInsertSlot.method_7960() && outputExtractSlot.method_7947() < outputExtractSlot.method_7914()) {
                FluidUtils.extractTankFluidToItem(this.getFluidContainer().getOutput(), this, 2, 3, 0, f -> true);
            }
            if (this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L) {
                List<FuelConversionRecipe> recipes = FuelConversionRecipe.getRecipes(this.field_11863);
                if (FluidUtils.convertFluid(this.getFluidContainer(), recipes, FluidHooks.buckets((int)1) / 50L)) {
                    this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), false);
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        }
    }

    @Override
    public long getEnergyPerTick() {
        return FuelRefineryConfig.energyPerTick;
    }

    @Override
    public InsertOnlyEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new InsertOnlyEnergyContainer((Updatable)this, (long)((int)FuelRefineryConfig.maxEnergy))) : this.energyContainer;
    }
}

