/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.pipe;

import earth.terrarium.ad_astra.common.block.pipe.InteractablePipe;
import earth.terrarium.ad_astra.common.block.pipe.Pipe;
import earth.terrarium.ad_astra.common.block.pipe.PipeBlock;
import earth.terrarium.ad_astra.common.block.pipe.PipeDuctBlock;
import earth.terrarium.ad_astra.common.block.pipe.PipeState;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.PlatformFluidHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;

public class FluidPipeBlockEntity
extends class_2586
implements InteractablePipe<PlatformFluidHandler> {
    private final List<InteractablePipe.Node<PlatformFluidHandler>> consumers = new ArrayList<InteractablePipe.Node<PlatformFluidHandler>>();
    private InteractablePipe.Node<PlatformFluidHandler> source;

    public FluidPipeBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntityTypes.FLUID_PIPE.get(), pos, state);
    }

    @Override
    public boolean supportsAutoExtract() {
        return true;
    }

    @Override
    public boolean canConnectTo(class_2586 next, class_2350 direction, class_2338 pos) {
        return true;
    }

    @Override
    public void insertInto(PlatformFluidHandler consumer, class_2350 direction, class_2338 pos) {
        if (this.field_11863 == null) {
            return;
        }
        class_2680 state = this.method_11010();
        class_2680 state2 = this.field_11863.method_8320(pos);
        if (state.method_26215() || state2.method_26215()) {
            return;
        }
        PlatformFluidHandler input = null;
        PlatformFluidHandler output = null;
        if (!(state.method_26204() instanceof PipeDuctBlock) && !(state2.method_26204() instanceof PipeDuctBlock)) {
            if (this.getSource().storage() == null || this.getConsumers().isEmpty()) {
                return;
            }
            Optional optionalPipeState = state.method_28500((class_2769)PipeBlock.DIRECTIONS.get(this.getSource().direction()));
            Optional optionalPipeState2 = state2.method_28500((class_2769)PipeBlock.DIRECTIONS.get(direction));
            if (optionalPipeState.isEmpty() || optionalPipeState2.isEmpty()) {
                return;
            }
            PipeState pipeState = (PipeState)((Object)optionalPipeState.get());
            PipeState pipeState2 = (PipeState)((Object)optionalPipeState2.get());
            if (pipeState == PipeState.INSERT && pipeState2 == PipeState.INSERT) {
                return;
            }
            if (pipeState == PipeState.EXTRACT && pipeState2 == PipeState.EXTRACT) {
                return;
            }
            if (pipeState == PipeState.NONE || pipeState2 == PipeState.NONE) {
                return;
            }
            if (pipeState2 == PipeState.INSERT || pipeState == PipeState.EXTRACT) {
                input = this.source.storage();
                output = consumer;
            } else if (pipeState2 == PipeState.EXTRACT || pipeState == PipeState.INSERT) {
                input = consumer;
                output = this.source.storage();
            } else {
                return;
            }
        }
        if (input == null || output == null) {
            return;
        }
        for (FluidHolder fluid : input.getFluidTanks()) {
            if (fluid.isEmpty()) continue;
            FluidHolder transfer = FluidHooks.newFluidHolder((class_3611)fluid.getFluid(), (long)Math.min(((PipeBlock)this.method_11010().method_26204()).getTransferRate(), fluid.getFluidAmount()), (class_2487)fluid.getCompound());
            FluidHooks.moveFluid(input, output, (FluidHolder)transfer);
        }
    }

    @Override
    public PlatformFluidHandler getInteraction(class_1937 level, class_2338 pos, class_2350 direction) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity != null) {
            return FluidHooks.safeGetBlockFluidManager((class_2586)blockEntity, (class_2350)direction).orElse(null);
        }
        return null;
    }

    @Override
    public InteractablePipe.Node<PlatformFluidHandler> getSource() {
        return this.source;
    }

    @Override
    public void setSource(InteractablePipe.Node<PlatformFluidHandler> source) {
        this.source = source;
    }

    @Override
    public void clearSource() {
        this.source = null;
    }

    @Override
    public List<InteractablePipe.Node<PlatformFluidHandler>> getConsumers() {
        return this.consumers;
    }

    @Override
    public int getWorkTime() {
        return 5;
    }

    @Override
    public class_1937 getPipelevel() {
        return this.field_11863;
    }

    @Override
    public long getTransferAmount() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof Pipe) {
            Pipe pipe = (Pipe)class_22482;
            return pipe.getTransferRate();
        }
        return 0L;
    }

    @Override
    public class_2338 getPipePos() {
        return this.method_11016();
    }
}

