/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import earth.terrarium.ad_astra.common.compat.emi.EmiCategories;
import earth.terrarium.ad_astra.common.compat.emi.EmiTextures;
import earth.terrarium.ad_astra.common.config.FuelRefineryConfig;
import earth.terrarium.ad_astra.common.recipe.FuelConversionRecipe;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6880;

public class EmiFluidConversionRecipe
implements EmiRecipe {
    private final class_2960 id;
    FuelConversionRecipe recipe;
    private final FluidEmiStack input;
    private final FluidEmiStack output;

    public EmiFluidConversionRecipe(FuelConversionRecipe recipe) {
        this.id = recipe.method_8114();
        this.recipe = recipe;
        this.input = new FluidEmiStack((FluidVariant)recipe.getFluidInput().method_40239().map(class_6880::comp_349).filter(f -> f.method_15793(f.method_15785())).map(FluidVariant::of).collect(Collectors.toList()).get(0), 81000L);
        this.output = new FluidEmiStack(FluidVariant.of((class_3611)recipe.getFluidOutput()), 81000L);
    }

    public EmiRecipeCategory getCategory() {
        return EmiCategories.FUEL_CONVERSION_CATEGORY;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return 90;
    }

    public void addWidgets(WidgetHolder widgets) {
        int xOffset = 20;
        int yOffset = 30;
        widgets.addFillingArrow(26 + xOffset, 1 + yOffset, 1000);
        EmiTextures.createFluidWidget(widgets, -10 + xOffset, -17 + yOffset, FluidVariant.of((class_3611)((class_3611)this.input.getKey())), 7500, false);
        EmiTextures.createFluidWidget(widgets, 60 + xOffset, -17 + yOffset, FluidVariant.of((class_3611)((class_3611)this.output.getKey())), 7500, true);
        EmiTextures.createEnergyWidget(widgets, 100 + xOffset, -20 + yOffset, (int)FuelRefineryConfig.energyPerTick, false);
    }
}

