/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.container;

import earth.terrarium.ad_astra.common.config.WaterPumpConfig;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.FluidSnapshot;
import earth.terrarium.botarium.api.fluid.UpdatingFluidContainer;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class WaterPumpFluidTank
implements UpdatingFluidContainer<class_2586> {
    private FluidHolder tank;
    private final Updatable updatable;

    public WaterPumpFluidTank(FluidHolder tank, Updatable updatable) {
        this.tank = tank;
        this.updatable = updatable;
    }

    public WaterPumpFluidTank(Updatable updatable) {
        this(FluidHooks.emptyFluid(), updatable);
    }

    public long insertFluid(FluidHolder fluid, boolean simulate) {
        return 0L;
    }

    public long insertInternal(FluidHolder fluid, boolean simulate) {
        if (fluid.isEmpty()) {
            return 0L;
        }
        if (this.tank.isEmpty()) {
            class_2487 compound = fluid.getCompound() != null ? fluid.getCompound().method_10553() : null;
            FluidHolder fluidHolder = FluidHooks.newFluidHolder((class_3611)fluid.getFluid(), (long)Math.min(this.getTankCapacity(0), fluid.getFluidAmount()), (class_2487)compound);
            if (!simulate) {
                this.tank = fluidHolder;
            }
            return fluidHolder.getFluidAmount();
        }
        if (!this.tank.getFluid().equals(fluid.getFluid())) {
            return 0L;
        }
        long amount = Math.min(this.getTankCapacity(0) - this.tank.getFluidAmount(), fluid.getFluidAmount());
        if (!simulate) {
            this.tank.setAmount(this.tank.getFluidAmount() + amount);
        }
        return amount;
    }

    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        if (this.tank.isEmpty()) {
            return FluidHooks.emptyFluid();
        }
        if (fluid.isEmpty()) {
            return FluidHooks.emptyFluid();
        }
        if (!fluid.getFluid().equals(class_3612.field_15910)) {
            return FluidHooks.emptyFluid();
        }
        if (!Objects.equals(fluid.getCompound(), this.tank.getCompound())) {
            return FluidHooks.emptyFluid();
        }
        long amount = Math.min(this.tank.getFluidAmount(), fluid.getFluidAmount());
        if (!simulate) {
            this.tank.setAmount(this.tank.getFluidAmount() - amount);
        }
        class_2487 compound = fluid.getCompound() != null ? fluid.getCompound().method_10553() : null;
        return FluidHooks.newFluidHolder((class_3611)fluid.getFluid(), (long)amount, (class_2487)compound);
    }

    public void setFluid(int slot, FluidHolder fluid) {
        if (slot == 0 && fluid.getFluid().equals(class_3612.field_15910)) {
            this.tank = fluid.copyHolder();
        }
    }

    public List<FluidHolder> getFluids() {
        return List.of(this.tank);
    }

    public int getSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.tank.isEmpty();
    }

    public FluidContainer copy() {
        return new WaterPumpFluidTank(this.tank.copyHolder(), this.updatable);
    }

    public long getTankCapacity(int tankSlot) {
        return WaterPumpConfig.tankSize;
    }

    public void fromContainer(FluidContainer container) {
        this.tank = ((FluidHolder)container.getFluids().get(0)).copyHolder();
    }

    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        if (Objects.equals(fluidHolder.getCompound(), toInsert.getCompound()) && fluidHolder.getFluid().method_15780(toInsert.getFluid())) {
            long amount = class_3532.method_24156((long)toInsert.getFluidAmount(), (long)0L, (long)fluidHolder.getFluidAmount());
            snapshot.run();
            fluidHolder.setAmount(fluidHolder.getFluidAmount() - amount);
            if (fluidHolder.getFluidAmount() == 0L) {
                fluidHolder.setFluid(class_3612.field_15906);
            }
            return amount;
        }
        return 0L;
    }

    public boolean allowsInsertion() {
        return false;
    }

    public boolean allowsExtraction() {
        return true;
    }

    public FluidSnapshot createSnapshot() {
        return new WaterPumpSnapshot(this.tank);
    }

    public void deserialize(class_2487 nbtCompound) {
        this.tank = FluidHooks.fluidFromCompound((class_2487)nbtCompound.method_10562("Tank"));
    }

    public class_2487 serialize(class_2487 nbtCompound) {
        nbtCompound.method_10566("Tank", (class_2520)this.tank.serialize());
        return nbtCompound;
    }

    public void update(class_2586 block) {
        this.updatable.update();
    }

    private record WaterPumpSnapshot(FluidHolder tank) implements FluidSnapshot
    {
        private WaterPumpSnapshot(FluidHolder tank) {
            this.tank = tank.copyHolder();
        }

        public void loadSnapshot(FluidContainer container) {
            container.setFluid(0, this.tank);
        }
    }
}

