/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.UnifyTag;
import com.almostreliable.unified.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public final class HideHelper {
    private HideHelper() {
    }

    public static Collection<class_1799> createHidingList(AlmostUnifiedRuntime runtime) {
        ReplacementMap repMap = runtime.getReplacementMap().orElse(null);
        TagMap tagMap = runtime.getFilteredTagMap().orElse(null);
        if (repMap == null || tagMap == null) {
            return new ArrayList<class_1799>();
        }
        HashSet hidingList = new HashSet();
        for (UnifyTag unifyTag : tagMap.getTags()) {
            Set<class_2960> itemsByTag = tagMap.getEntriesByTag(unifyTag);
            if (Utils.allSameNamespace(itemsByTag)) continue;
            HashSet<class_2960> replacements = new HashSet<class_2960>();
            for (class_2960 item : itemsByTag) {
                replacements.add(HideHelper.getReplacementForItem(repMap, item));
            }
            HashSet<class_2960> toHide = new HashSet<class_2960>();
            for (class_2960 item : itemsByTag) {
                if (replacements.contains(item)) continue;
                toHide.add(item);
            }
            if (toHide.isEmpty()) continue;
            AlmostUnified.LOG.info("[AutoHiding] Hiding {}/{} items for tag '#{}' -> {}", (Object)toHide.size(), (Object)itemsByTag.size(), (Object)unifyTag.location(), toHide);
            hidingList.addAll(toHide);
        }
        hidingList.addAll(HideHelper.getRefItems(repMap));
        return hidingList.stream().flatMap(rl -> class_2378.field_11142.method_17966(rl).stream()).map(class_1799::new).collect(Collectors.toList());
    }

    private static class_2960 getReplacementForItem(ReplacementMap repMap, class_2960 item) {
        class_2960 replacement = repMap.getReplacementForItem(item);
        if (replacement == null) {
            return item;
        }
        return replacement;
    }

    private static Set<class_2960> getRefItems(ReplacementMap repMap) {
        HashSet<class_2960> hidingList = new HashSet<class_2960>();
        TagOwnerships ownerships = repMap.getTagOwnerships();
        ownerships.getRefs().forEach(ref -> {
            UnifyTag<class_1792> owner = ownerships.getOwnerByTag((UnifyTag<class_1792>)ref);
            assert (owner != null);
            class_2960 dominantItem = repMap.getPreferredItemForTag(owner, $ -> true);
            class_6862 asTagKey = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)ref.location());
            HashSet refItems = new HashSet();
            class_2378.field_11142.method_40286(asTagKey).forEach(holder -> {
                class_2960 item = class_2378.field_11142.method_10221((Object)((class_1792)holder.comp_349()));
                if (item.equals((Object)dominantItem)) {
                    return;
                }
                refItems.add(item);
            });
            if (refItems.isEmpty()) {
                return;
            }
            AlmostUnified.LOG.info("[AutoHiding] Hiding reference tag '#{}' of owner tag '#{}' -> {}", (Object)ref.location(), (Object)owner.location(), refItems);
            hidingList.addAll(refItems);
        });
        return hidingList;
    }
}

