/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.utils.UnifyTag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class TagMap<T> {
    private final Map<UnifyTag<T>, Set<class_2960>> tagsToEntries = new HashMap<UnifyTag<T>, Set<class_2960>>();
    private final Map<class_2960, Set<UnifyTag<T>>> entriesToTags = new HashMap<class_2960, Set<UnifyTag<T>>>();

    protected TagMap() {
    }

    public static TagMap<class_1792> create(Set<UnifyTag<class_1792>> unifyTags) {
        TagMap<class_1792> tagMap = new TagMap<class_1792>();
        unifyTags.forEach(ut -> {
            class_6862 asTagKey = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)ut.location());
            class_2378.field_11142.method_40286(asTagKey).forEach(holder -> {
                class_2960 key = class_2378.field_11142.method_10221((Object)((class_1792)holder.comp_349()));
                tagMap.put((UnifyTag<class_1792>)ut, key);
            });
        });
        return tagMap;
    }

    public static TagMap<class_1792> createFromItemTags(Map<class_2960, Collection<class_6880<class_1792>>> tags) {
        TagMap<class_1792> tagMap = new TagMap<class_1792>();
        for (Map.Entry<class_2960, Collection<class_6880<class_1792>>> entry : tags.entrySet()) {
            UnifyTag<class_1792> unifyTag = UnifyTag.item(entry.getKey());
            TagMap.fillEntries(tagMap, entry.getValue(), unifyTag, class_2378.field_11142);
        }
        return tagMap;
    }

    public static TagMap<class_2248> createFromBlockTags(Map<class_2960, Collection<class_6880<class_2248>>> tags) {
        TagMap<class_2248> tagMap = new TagMap<class_2248>();
        for (Map.Entry<class_2960, Collection<class_6880<class_2248>>> entry : tags.entrySet()) {
            UnifyTag<class_2248> unifyTag = UnifyTag.block(entry.getKey());
            TagMap.fillEntries(tagMap, entry.getValue(), unifyTag, class_2378.field_11146);
        }
        return tagMap;
    }

    private static <T> void fillEntries(TagMap<T> tagMap, Collection<class_6880<T>> holders, UnifyTag<T> unifyTag, class_2378<T> registry) {
        for (class_6880<T> holder : holders) {
            holder.method_40230().map(class_5321::method_29177).filter(arg_0 -> registry.method_10250(arg_0)).ifPresent(id -> tagMap.put(unifyTag, (class_2960)id));
        }
    }

    public TagMap<T> filtered(Predicate<UnifyTag<T>> tagFilter, Predicate<class_2960> entryFilter) {
        TagMap tagMap = new TagMap();
        this.tagsToEntries.forEach((tag, items) -> {
            if (!tagFilter.test((UnifyTag)tag)) {
                return;
            }
            items.stream().filter(entryFilter).forEach(item -> tagMap.put((UnifyTag)tag, (class_2960)item));
        });
        return tagMap;
    }

    public int tagSize() {
        return this.tagsToEntries.size();
    }

    public int itemSize() {
        return this.entriesToTags.size();
    }

    public Set<class_2960> getEntriesByTag(UnifyTag<T> tag) {
        return Collections.unmodifiableSet(this.tagsToEntries.getOrDefault(tag, Collections.emptySet()));
    }

    public Set<UnifyTag<T>> getTagsByEntry(class_2960 entry) {
        return Collections.unmodifiableSet(this.entriesToTags.getOrDefault(entry, Collections.emptySet()));
    }

    public Set<UnifyTag<T>> getTags() {
        return Collections.unmodifiableSet(this.tagsToEntries.keySet());
    }

    protected void put(UnifyTag<T> tag, class_2960 entry) {
        this.tagsToEntries.computeIfAbsent(tag, k -> new HashSet()).add(entry);
        this.entriesToTags.computeIfAbsent(entry, k -> new HashSet()).add(tag);
    }
}

