/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.ReplacementData;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UnifyTag;
import com.almostreliable.unified.utils.Utils;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public final class TagReloadHandler {
    private static final Object LOCK = new Object();
    private static Map<class_2960, Collection<class_6880<class_1792>>> RAW_ITEM_TAGS;
    private static Map<class_2960, Collection<class_6880<class_2248>>> RAW_BLOCK_TAGS;

    private TagReloadHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initItemTags(Map<class_2960, Collection<class_6880<class_1792>>> rawItemTags) {
        Object object = LOCK;
        synchronized (object) {
            RAW_ITEM_TAGS = rawItemTags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initBlockTags(Map<class_2960, Collection<class_6880<class_2248>>> rawBlockTags) {
        Object object = LOCK;
        synchronized (object) {
            RAW_BLOCK_TAGS = rawBlockTags;
        }
    }

    public static void run() {
        if (RAW_ITEM_TAGS == null || RAW_BLOCK_TAGS == null) {
            return;
        }
        AlmostUnified.onTagLoaderReload(RAW_ITEM_TAGS);
        RAW_ITEM_TAGS = null;
        RAW_BLOCK_TAGS = null;
    }

    public static void applyCustomTags(UnifyConfig unifyConfig) {
        Preconditions.checkNotNull(RAW_ITEM_TAGS, (Object)"Item tags were not loaded correctly");
        HashMultimap changedItemTags = HashMultimap.create();
        for (Map.Entry<class_2960, Set<class_2960>> entry : unifyConfig.getCustomTags().entrySet()) {
            class_2960 tag2 = entry.getKey();
            Set<class_2960> itemIds = entry.getValue();
            for (class_2960 itemId : itemIds) {
                if (!class_2378.field_11142.method_10250(itemId)) {
                    AlmostUnified.LOG.warn("[CustomTags] Custom tag '{}' contains invalid item '{}'", (Object)tag2, (Object)itemId);
                    continue;
                }
                class_5321 itemKey = class_5321.method_29179((class_5321)class_2378.field_25108, (class_2960)itemId);
                class_6880 itemHolder = class_2378.field_11142.method_40264(itemKey).orElse(null);
                if (itemHolder == null) continue;
                ImmutableSet.Builder newHolders = ImmutableSet.builder();
                Collection<class_6880<class_1792>> currentHolders = RAW_ITEM_TAGS.get(tag2);
                if (currentHolders != null) {
                    if (currentHolders.contains(itemHolder)) {
                        AlmostUnified.LOG.warn("[CustomTags] Custom tag '{}' already contains item '{}'", (Object)tag2, (Object)itemId);
                        continue;
                    }
                    newHolders.addAll(currentHolders);
                }
                newHolders.add((Object)itemHolder);
                RAW_ITEM_TAGS.put(tag2, (Collection<class_6880<class_1792>>)newHolders.build());
                changedItemTags.put((Object)tag2, (Object)itemId);
            }
        }
        if (!changedItemTags.isEmpty()) {
            changedItemTags.asMap().forEach((tag, items) -> AlmostUnified.LOG.info("[CustomTags] Modified tag '#{}', added {}", tag, items));
        }
    }

    public static boolean applyInheritance(UnifyConfig unifyConfig, ReplacementData replacementData) {
        Preconditions.checkNotNull(RAW_ITEM_TAGS, (Object)"Item tags were not loaded correctly");
        Preconditions.checkNotNull(RAW_BLOCK_TAGS, (Object)"Block tags were not loaded correctly");
        HashMultimap changedItemTags = HashMultimap.create();
        HashMultimap changedBlockTags = HashMultimap.create();
        Set<TagRelation> relations = TagReloadHandler.resolveRelations(replacementData.filteredTagMap(), replacementData.replacementMap());
        if (relations.isEmpty()) {
            return false;
        }
        TagMap<class_2248> blockTagMap = TagMap.createFromBlockTags(RAW_BLOCK_TAGS);
        TagMap<class_1792> globalTagMap = replacementData.globalTagMap();
        for (TagRelation relation : relations) {
            class_2960 dominant2 = relation.dominant;
            class_6880<class_1792> dominantItemHolder = TagReloadHandler.findDominantItemHolder(relation);
            class_6880<class_2248> dominantBlockHolder = TagReloadHandler.findDominantBlockHolder(blockTagMap, dominant2);
            Set<UnifyTag<class_1792>> dominantItemTags = globalTagMap.getTagsByEntry(dominant2);
            for (class_2960 item : relation.items) {
                Set<class_2960> changed;
                if (dominantItemHolder != null) {
                    changed = TagReloadHandler.applyItemTags(unifyConfig, globalTagMap, dominantItemHolder, dominantItemTags, item);
                    changedItemTags.putAll((Object)dominant2, changed);
                }
                if (dominantBlockHolder == null) continue;
                changed = TagReloadHandler.applyBlockTags(unifyConfig, blockTagMap, dominantBlockHolder, dominantItemTags, item);
                changedBlockTags.putAll((Object)dominant2, changed);
            }
        }
        if (!changedBlockTags.isEmpty()) {
            changedBlockTags.asMap().forEach((dominant, tags) -> AlmostUnified.LOG.info("[TagInheritance] Added '{}' to block tags {}", dominant, tags));
        }
        if (!changedItemTags.isEmpty()) {
            changedItemTags.asMap().forEach((dominant, tags) -> AlmostUnified.LOG.info("[TagInheritance] Added '{}' to item tags {}", dominant, tags));
            return true;
        }
        return false;
    }

    private static Set<TagRelation> resolveRelations(TagMap<class_1792> filteredTagMap, ReplacementMap repMap) {
        HashSet<TagRelation> relations = new HashSet<TagRelation>();
        for (UnifyTag<class_1792> unifyTag : filteredTagMap.getTags()) {
            Set<class_2960> items;
            class_2960 dominant;
            Set<class_2960> itemsByTag = filteredTagMap.getEntriesByTag(unifyTag);
            if (Utils.allSameNamespace(itemsByTag) || (dominant = repMap.getPreferredItemForTag(unifyTag, $ -> true)) == null || !class_2378.field_11142.method_10250(dominant) || (items = TagReloadHandler.getValidatedItems(itemsByTag, dominant)).isEmpty()) continue;
            relations.add(new TagRelation(unifyTag.location(), dominant, items));
        }
        return relations;
    }

    private static Set<class_2960> getValidatedItems(Set<class_2960> itemIds, class_2960 dominant) {
        HashSet<class_2960> result = new HashSet<class_2960>(itemIds.size());
        for (class_2960 id : itemIds) {
            if (id.equals((Object)dominant) || !class_2378.field_11142.method_10250(id)) continue;
            result.add(id);
        }
        return result;
    }

    @Nullable
    private static class_6880<class_1792> findDominantItemHolder(TagRelation relation) {
        Collection tagHolders = RAW_ITEM_TAGS.get(relation.tag);
        if (tagHolders == null) {
            return null;
        }
        return TagReloadHandler.findDominantHolder(tagHolders, relation.dominant);
    }

    @Nullable
    private static class_6880<class_2248> findDominantBlockHolder(TagMap<class_2248> tagMap, class_2960 dominant) {
        Set<UnifyTag<class_2248>> blockTags = tagMap.getTagsByEntry(dominant);
        if (blockTags.isEmpty()) {
            return null;
        }
        Collection tagHolders = RAW_BLOCK_TAGS.get(blockTags.iterator().next().location());
        if (tagHolders == null) {
            return null;
        }
        return TagReloadHandler.findDominantHolder(tagHolders, dominant);
    }

    @Nullable
    private static <T> class_6880<T> findDominantHolder(Collection<class_6880<T>> holders, class_2960 dominant) {
        for (class_6880<T> tagHolder : holders) {
            Optional holderKey = tagHolder.method_40230();
            if (!holderKey.isPresent() || !((class_5321)holderKey.get()).method_29177().equals((Object)dominant)) continue;
            return tagHolder;
        }
        return null;
    }

    private static Set<class_2960> applyItemTags(UnifyConfig unifyConfig, TagMap<class_1792> globalTagMap, class_6880<class_1792> dominantItemHolder, Set<UnifyTag<class_1792>> dominantItemTags, class_2960 item) {
        Set<UnifyTag<class_1792>> itemTags = globalTagMap.getTagsByEntry(item);
        HashSet<class_2960> changed = new HashSet<class_2960>();
        for (UnifyTag<class_1792> itemTag : itemTags) {
            if (!unifyConfig.shouldInheritItemTag(itemTag, dominantItemTags) || !TagReloadHandler.tryUpdatingRawTags(dominantItemHolder, itemTag, RAW_ITEM_TAGS)) continue;
            changed.add(itemTag.location());
        }
        return changed;
    }

    private static Set<class_2960> applyBlockTags(UnifyConfig unifyConfig, TagMap<class_2248> blockTagMap, class_6880<class_2248> dominantBlockHolder, Set<UnifyTag<class_1792>> dominantItemTags, class_2960 item) {
        Set<UnifyTag<class_2248>> blockTags = blockTagMap.getTagsByEntry(item);
        HashSet<class_2960> changed = new HashSet<class_2960>();
        for (UnifyTag<class_2248> blockTag : blockTags) {
            if (!unifyConfig.shouldInheritBlockTag(blockTag, dominantItemTags) || !TagReloadHandler.tryUpdatingRawTags(dominantBlockHolder, blockTag, RAW_BLOCK_TAGS)) continue;
            changed.add(blockTag.location());
        }
        return changed;
    }

    private static <T> boolean tryUpdatingRawTags(class_6880<T> dominantHolder, UnifyTag<T> tag, Map<class_2960, Collection<class_6880<T>>> rawTags) {
        Collection<class_6880<T>> tagHolders = rawTags.get(tag.location());
        if (tagHolders == null) {
            return false;
        }
        if (tagHolders.contains(dominantHolder)) {
            return false;
        }
        ImmutableSet.Builder newHolders = ImmutableSet.builder();
        newHolders.addAll(tagHolders);
        newHolders.add(dominantHolder);
        rawTags.put(tag.location(), (Collection<class_6880<T>>)newHolders.build());
        return true;
    }

    private record TagRelation(class_2960 tag, class_2960 dominant, Set<class_2960> items) {
    }
}

