/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.IPatternDetailsDecoder;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AEPatternDecoder;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_3975;
import net.minecraft.class_5357;

public final class PatternDetailsHelper {
    private static final List<IPatternDetailsDecoder> DECODERS = new CopyOnWriteArrayList<IPatternDetailsDecoder>();

    public static void registerDecoder(IPatternDetailsDecoder decoder) {
        Objects.requireNonNull(decoder);
        DECODERS.add(decoder);
    }

    public static boolean isEncodedPattern(class_1799 stack) {
        for (IPatternDetailsDecoder decoder : DECODERS) {
            if (!decoder.isEncodedPattern(stack)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static IPatternDetails decodePattern(class_1799 stack, class_1937 level) {
        return PatternDetailsHelper.decodePattern(stack, level, false);
    }

    @Nullable
    public static IPatternDetails decodePattern(AEItemKey what, class_1937 level) {
        for (IPatternDetailsDecoder decoder : DECODERS) {
            IPatternDetails decoded = decoder.decodePattern(what, level);
            if (decoded == null) continue;
            return decoded;
        }
        return null;
    }

    @Nullable
    public static IPatternDetails decodePattern(class_1799 stack, class_1937 level, boolean autoRecovery) {
        for (IPatternDetailsDecoder decoder : DECODERS) {
            IPatternDetails decoded = decoder.decodePattern(stack, level, autoRecovery);
            if (decoded == null) continue;
            return decoded;
        }
        return null;
    }

    public static class_1799 encodeProcessingPattern(GenericStack[] in, GenericStack[] out) {
        return AEItems.PROCESSING_PATTERN.method_8389().encode(in, out);
    }

    public static class_1799 encodeCraftingPattern(class_3955 recipe, class_1799[] in, class_1799 out, boolean allowSubstitutes, boolean allowFluidSubstitutes) {
        return AEItems.CRAFTING_PATTERN.method_8389().encode(recipe, in, out, allowSubstitutes, allowFluidSubstitutes);
    }

    public static class_1799 encodeStonecuttingPattern(class_3975 recipe, AEItemKey in, AEItemKey out, boolean allowSubstitutes) {
        Preconditions.checkNotNull((Object)recipe, (Object)"recipe");
        Preconditions.checkNotNull((Object)in, (Object)"in");
        Preconditions.checkNotNull((Object)out, (Object)"out");
        return AEItems.STONECUTTING_PATTERN.method_8389().encode(recipe, in, out, allowSubstitutes);
    }

    public static class_1799 encodeSmithingTablePattern(class_5357 recipe, AEItemKey base, AEItemKey addition, AEItemKey out, boolean allowSubstitutes) {
        Preconditions.checkNotNull((Object)recipe, (Object)"recipe");
        Preconditions.checkNotNull((Object)base, (Object)"base");
        Preconditions.checkNotNull((Object)addition, (Object)"addition");
        Preconditions.checkNotNull((Object)out, (Object)"out");
        return AEItems.SMITHING_TABLE_PATTERN.method_8389().encode(recipe, base, addition, out, allowSubstitutes);
    }

    static {
        PatternDetailsHelper.registerDecoder(AEPatternDecoder.INSTANCE);
    }
}

