/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.FuzzySearch;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

abstract class VariantMap<K extends AEKey, V> {
    private final V defaultValue;
    private final Supplier<V> defaultValueFactory;

    public static <K extends AEKey, V> VariantMap<K, V> create(K keyTemplate, V defaultValue, Supplier<V> defaultValueFactory) {
        if (keyTemplate.getFuzzySearchMaxValue() > 0) {
            return new FuzzyVariantMap(defaultValue, defaultValueFactory);
        }
        return new UnorderedVariantMap(defaultValue, defaultValueFactory);
    }

    public VariantMap(V defaultValue, Supplier<V> defaultValueSupplier) {
        this.defaultValue = defaultValue;
        this.defaultValueFactory = defaultValueSupplier;
    }

    public V mapping(K key) {
        return (V)this.getRecords().computeIfAbsent((AEKey)key, this::createDefaultValue);
    }

    private V createDefaultValue(K k) {
        return this.defaultValueFactory.get();
    }

    public V findPrecise(K key) {
        return this.getRecords().get(key);
    }

    public abstract Collection<Map.Entry<K, V>> findFuzzy(K var1, FuzzyMode var2);

    public int size() {
        int size = 0;
        for (V value : this.getRecords().values()) {
            if (!value.equals(this.defaultValue)) continue;
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        for (V value : this.getRecords().values()) {
            if (value.equals(this.defaultValue)) continue;
            return false;
        }
        return true;
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return new NonDefaultIterator();
    }

    abstract Map<K, V> getRecords();

    private static class FuzzyVariantMap<K extends AEKey, V>
    extends VariantMap<K, V> {
        private final Object2ObjectSortedMap<K, V> records = FuzzySearch.createMap();

        public FuzzyVariantMap(V defaultValue, Supplier<V> defaultValueSupplier) {
            super(defaultValue, defaultValueSupplier);
        }

        @Override
        public Collection<Map.Entry<K, V>> findFuzzy(K key, FuzzyMode fuzzy) {
            return FuzzySearch.findFuzzy(this.records, key, fuzzy).entrySet();
        }

        @Override
        Map<K, V> getRecords() {
            return this.records;
        }
    }

    private static class UnorderedVariantMap<K extends AEKey, V>
    extends VariantMap<K, V> {
        private final Object2ObjectMap<K, V> records = new Object2ObjectOpenHashMap();

        public UnorderedVariantMap(V defaultValue, Supplier<V> defaultValueSupplier) {
            super(defaultValue, defaultValueSupplier);
        }

        @Override
        public Collection<Map.Entry<K, V>> findFuzzy(K filter, FuzzyMode fuzzy) {
            return this.records.entrySet();
        }

        @Override
        Map<K, V> getRecords() {
            return this.records;
        }
    }

    private class NonDefaultIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> parent;
        private Map.Entry<K, V> next;

        public NonDefaultIterator() {
            this.parent = VariantMap.this.getRecords().entrySet().iterator();
            this.next = this.seekNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Map.Entry result = this.next;
            this.next = this.seekNext();
            return result;
        }

        private Map.Entry<K, V> seekNext() {
            while (this.parent.hasNext()) {
                Map.Entry entry = this.parent.next();
                if (entry.getValue().equals(VariantMap.this.defaultValue)) {
                    this.parent.remove();
                    continue;
                }
                return entry;
            }
            return null;
        }
    }
}

