/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.storage;

import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.minecraft.class_1799;

@ThreadSafe
public final class StorageCells {
    private static final List<ICellHandler> handlers = new ArrayList<ICellHandler>();
    private static final List<ICellGuiHandler> guiHandlers = new ArrayList<ICellGuiHandler>();

    private StorageCells() {
    }

    public static synchronized void addCellHandler(ICellHandler handler) {
        Objects.requireNonNull(handler, "Called before FMLCommonSetupEvent.");
        Preconditions.checkArgument((!handlers.contains(handler) ? 1 : 0) != 0, (Object)"Tried to register the same handler instance twice.");
        handlers.add(handler);
    }

    public static synchronized void addCellGuiHandler(ICellGuiHandler handler) {
        guiHandlers.add(handler);
    }

    public static synchronized boolean isCellHandled(class_1799 is) {
        if (is.method_7960()) {
            return false;
        }
        for (ICellHandler ch : handlers) {
            if (!ch.isCell(is)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static synchronized ICellHandler getHandler(class_1799 is) {
        if (is.method_7960()) {
            return null;
        }
        for (ICellHandler ch : handlers) {
            if (!ch.isCell(is)) continue;
            return ch;
        }
        return null;
    }

    @Nullable
    public static synchronized ICellGuiHandler getGuiHandler(class_1799 is) {
        ICellGuiHandler fallBack = null;
        for (ICellGuiHandler ch : guiHandlers) {
            if (ch.isSpecializedFor(is)) {
                return ch;
            }
            if (fallBack != null) continue;
            fallBack = ch;
        }
        return fallBack;
    }

    @Nullable
    public static synchronized StorageCell getCellInventory(class_1799 is, @Nullable ISaveProvider host) {
        if (is.method_7960()) {
            return null;
        }
        for (ICellHandler ch : handlers) {
            StorageCell inventory = ch.getCellInventory(is, host);
            if (inventory == null) continue;
            return inventory;
        }
        return null;
    }
}

