/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.CrankBlockEntity;
import appeng.util.FakePlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class CrankBlock
extends AEBaseEntityBlock<CrankBlockEntity>
implements IOrientableBlock {
    public CrankBlock(class_4970.class_2251 props) {
        super(props);
    }

    @Override
    public class_1269 onActivated(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        if (player instanceof FakePlayer || player == null) {
            this.dropCrank(level, pos);
            return class_1269.method_29236((boolean)level.method_8608());
        }
        CrankBlockEntity crank = (CrankBlockEntity)this.getBlockEntity((class_1922)level, pos);
        if (crank != null) {
            crank.power();
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    private void dropCrank(class_1937 level, class_2338 pos) {
        level.method_22352(pos, true);
        level.method_8413(pos, this.method_9564(), level.method_8320(pos), 3);
    }

    @Override
    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 is) {
        super.method_9567(level, pos, state, placer, is);
        CrankBlockEntity be = (CrankBlockEntity)this.getBlockEntity((class_1922)level, pos);
        if (be != null) {
            class_2350 mnt = this.findCrankableDirection(level, pos);
            if (mnt == null) {
                this.dropCrank(level, pos);
                return;
            }
            class_2350 forward = class_2350.field_11036;
            if (mnt == class_2350.field_11036 || mnt == class_2350.field_11033) {
                forward = class_2350.field_11035;
            }
            be.setOrientation(forward, mnt.method_10153());
        } else {
            this.dropCrank(level, pos);
        }
    }

    @Override
    protected boolean isValidOrientation(class_1936 levelAccessor, class_2338 pos, class_2350 forward, class_2350 up) {
        if (levelAccessor instanceof class_1937) {
            class_1937 level = (class_1937)levelAccessor;
            class_2586 be = level.method_8321(pos);
            return !(be instanceof CrankBlockEntity) || this.isCrankable(level, pos, up.method_10153());
        }
        return true;
    }

    private class_2350 findCrankableDirection(class_1937 level, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            if (!this.isCrankable(level, pos, dir)) continue;
            return dir;
        }
        return null;
    }

    private boolean isCrankable(class_1937 level, class_2338 pos, class_2350 offset) {
        class_2338 o = pos.method_10093(offset);
        return ICrankable.get(level, o, offset.method_10153()) != null;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        CrankBlockEntity be = (CrankBlockEntity)this.getBlockEntity((class_1922)level, pos);
        if (be != null) {
            if (!this.isCrankable(level, pos, be.getUp().method_10153())) {
                this.dropCrank(level, pos);
            }
        } else {
            this.dropCrank(level, pos);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 levelReader, class_2338 pos) {
        if (levelReader instanceof class_1937) {
            class_1937 level = (class_1937)levelReader;
            return this.findCrankableDirection(level, pos) != null;
        }
        return true;
    }

    private class_2350 getUp(class_1922 level, class_2338 pos) {
        CrankBlockEntity crank = (CrankBlockEntity)this.getBlockEntity(level, pos);
        return crank != null ? crank.getUp() : null;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_2350 up = this.getUp(level, pos);
        if (up == null) {
            return class_259.method_1073();
        }
        double xOff = -0.15 * (double)up.method_10148();
        double yOff = -0.15 * (double)up.method_10164();
        double zOff = -0.15 * (double)up.method_10165();
        return class_259.method_1078((class_238)new class_238(xOff + 0.15, yOff + 0.15, zOff + 0.15, xOff + 0.85, yOff + 0.85, zOff + 0.85));
    }
}

