/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.AppEngClient;
import appeng.helpers.AEMaterials;
import appeng.helpers.MetaRotation;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class QuartzFixtureBlock
extends AEBaseBlock
implements IOrientableBlock,
class_3737 {
    private static final Map<class_2350, class_265> SHAPES = new EnumMap<class_2350, class_265>(class_2350.class);
    public static final class_2753 FACING;
    public static final class_2746 ODD;
    public static final class_2746 WATERLOGGED;

    public QuartzFixtureBlock() {
        super(QuartzFixtureBlock.defaultProps(AEMaterials.FIXTURE).method_9634().method_22488().method_9632(0.0f).method_9631(b -> 14).method_9626(class_2498.field_11537));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11036)).method_11657((class_2769)ODD, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ODD, WATERLOGGED});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350[] adirection;
        class_2680 blockstate = super.method_9605(context);
        class_2338 pos = context.method_8037();
        class_3610 fluidState = context.method_8045().method_8316(pos);
        boolean oddPlacement = (pos.method_10263() + pos.method_10264() + pos.method_10260()) % 2 != 0;
        blockstate = (class_2680)((class_2680)blockstate.method_11657((class_2769)ODD, (Comparable)Boolean.valueOf(oddPlacement))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        class_1937 levelReader = context.method_8045();
        for (class_2350 direction : adirection = context.method_7718()) {
            if (!this.canPlaceAt((class_4538)levelReader, pos, direction)) continue;
            return (class_2680)blockstate.method_11657((class_2769)FACING, (Comparable)direction.method_10153());
        }
        return null;
    }

    public class_2680 method_9559(class_2680 blockState, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        class_2350 fixtureFacing = (class_2350)blockState.method_11654((class_2769)FACING);
        if (facing.method_10153() == fixtureFacing && !this.canPlaceAt((class_4538)level, currentPos, facing)) {
            return class_2246.field_10124.method_9564();
        }
        return blockState;
    }

    @Override
    public boolean isValidOrientation(class_1936 level, class_2338 pos, class_2350 forward, class_2350 up) {
        return this.canPlaceAt((class_4538)level, pos, up.method_10153());
    }

    private boolean canPlaceAt(class_4538 level, class_2338 pos, class_2350 dir) {
        return QuartzFixtureBlock.method_20044((class_4538)level, (class_2338)pos.method_10093(dir), (class_2350)dir.method_10153());
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        return SHAPES.get(facing);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        if ((double)r.method_43057() < 0.98) {
            return;
        }
        class_2350 up = this.getOrientable((class_1922)level, pos).getUp();
        double xOff = -0.3 * (double)up.method_10148();
        double yOff = -0.3 * (double)up.method_10164();
        double zOff = -0.3 * (double)up.method_10165();
        for (int bolts = 0; bolts < 3; ++bolts) {
            if (!AppEngClient.instance().shouldAddParticles(r)) continue;
            level.method_8406((class_2394)ParticleTypes.LIGHTNING, xOff + 0.5 + (double)pos.method_10263(), yOff + 0.5 + (double)pos.method_10264(), zOff + 0.5 + (double)pos.method_10260(), 0.0, 0.0, 0.0);
        }
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        class_2350 up = this.getOrientable((class_1922)level, pos).getUp();
        if (!this.canPlaceAt((class_4538)level, pos, up.method_10153())) {
            this.dropTorch(level, pos);
        }
    }

    private void dropTorch(class_1937 level, class_2338 pos) {
        class_2680 prev = level.method_8320(pos);
        level.method_22352(pos, true);
        level.method_8413(pos, prev, level.method_8320(pos), 3);
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            if (!this.canPlaceAt(level, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IOrientable getOrientable(class_1922 level, class_2338 pos) {
        return new MetaRotation(level, pos, (class_2769<class_2350>)FACING);
    }

    public class_3610 method_9545(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    static {
        for (class_2350 facing : class_2350.values()) {
            double xOff = -0.3 * (double)facing.method_10148();
            double yOff = -0.3 * (double)facing.method_10164();
            double zOff = -0.3 * (double)facing.method_10165();
            class_265 shape = class_259.method_1078((class_238)new class_238(xOff + 0.3, yOff + 0.3, zOff + 0.3, xOff + 0.7, yOff + 0.7, zOff + 0.7));
            SHAPES.put(facing, shape);
        }
        FACING = class_2741.field_12525;
        ODD = class_2746.method_11825((String)"odd");
        WATERLOGGED = class_2741.field_12508;
    }
}

