/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.implementations.blockentities.ICrankable;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class CrankBlockEntity
extends AEBaseBlockEntity
implements ServerTickingBlockEntity,
ClientTickingBlockEntity {
    public static final int POWER_PER_CRANK_TURN = 160;
    private final int ticksPerRotation = 18;
    private float visibleRotation = 0.0f;
    private int charge = 0;
    private int hits = 0;
    private int rotation = 0;

    public CrankBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Nullable
    private ICrankable getCrankable() {
        if (this.isClientSide()) {
            return null;
        }
        class_2350 targetDir = this.getUp().method_10153();
        class_2338 targetPos = this.method_11016().method_10093(targetDir);
        return ICrankable.get(this.field_11863, targetPos, targetDir.method_10153());
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        this.rotation = data.readInt();
        return c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeInt(this.rotation);
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        super.setOrientation(inForward, inUp);
        class_2338 pos = this.method_11016();
        class_2680 state = this.field_11863.method_8320(pos);
        this.field_11863.method_41410(state, pos, state.method_26204(), pos, false);
    }

    public boolean power() {
        ICrankable crankable;
        if (this.isClientSide()) {
            return false;
        }
        if (this.rotation < 3 && (crankable = this.getCrankable()) != null) {
            if (crankable.canTurn()) {
                this.hits = 0;
                this.rotation += this.ticksPerRotation;
                this.markForUpdate();
                return true;
            }
            ++this.hits;
            if (this.hits > 10) {
                this.field_11863.method_22352(this.method_11016(), false);
            }
        }
        return false;
    }

    public float getVisibleRotation() {
        return this.visibleRotation;
    }

    private void setVisibleRotation(float visibleRotation) {
        this.visibleRotation = visibleRotation;
    }

    @Override
    public void clientTick() {
        this.tick();
    }

    @Override
    public void serverTick() {
        this.tick();
    }

    private void tick() {
        if (this.rotation > 0) {
            float f = this.getVisibleRotation();
            Objects.requireNonNull(this);
            this.setVisibleRotation(f - 360.0f / 18.0f);
            ++this.charge;
            if (this.charge >= this.ticksPerRotation) {
                this.charge -= this.ticksPerRotation;
                ICrankable g = this.getCrankable();
                if (g != null) {
                    g.applyTurn();
                }
            }
            --this.rotation;
        }
    }
}

