/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.ids.AETags;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.AEConfig;
import java.util.EnumSet;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class QuartzGrowthAcceleratorBlockEntity
extends AENetworkBlockEntity
implements IPowerChannelState {
    public static final int MAX_STORED_POWER = 1600;
    private static final int POWER_PER_TICK = 8;
    private boolean hasPower = false;
    private float storedPower;

    public QuartzGrowthAcceleratorBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.noneOf(class_2350.class));
        this.getMainNode().setFlags(new GridFlags[0]);
        this.getMainNode().setIdlePowerUsage(8.0);
        this.getMainNode().addService(IGridTickable.class, new IGridTickable(){

            @Override
            public TickingRequest getTickingRequest(IGridNode node) {
                int speed = AEConfig.instance().getGrowthAcceleratorSpeed();
                return new TickingRequest(speed, speed, false, false);
            }

            @Override
            public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
                QuartzGrowthAcceleratorBlockEntity.this.onTick(ticksSinceLastCall);
                return TickRateModulation.SAME;
            }
        });
    }

    private void onTick(int ticksSinceLastCall) {
        if (this.storedPower > 0.0f) {
            this.storedPower -= (float)(8 * Math.max(1, ticksSinceLastCall));
            if (this.storedPower <= 0.0f) {
                this.storedPower = 0.0f;
                this.markForUpdate();
            }
        } else if (!this.getMainNode().isPowered()) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 adjPos = this.method_11016().method_10093(direction);
            class_2680 adjState = this.method_10997().method_8320(adjPos);
            if (!adjState.method_26164(AETags.GROWTH_ACCELERATABLE)) continue;
            adjState.method_26199((class_3218)this.method_10997(), adjPos, this.method_10997().method_8409());
        }
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason == IGridNodeListener.State.POWER) {
            this.markForUpdate();
        }
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    public boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        boolean hadPower = this.isPowered();
        this.setPowered(data.readBoolean());
        return this.isPowered() != hadPower || c;
    }

    @Override
    public void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.getMainNode().isPowered());
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        super.setOrientation(inForward, inUp);
        this.getMainNode().setExposedOnSides(EnumSet.of(this.getUp(), this.getUp().method_10153()));
    }

    @Override
    public void onReady() {
        this.getMainNode().setExposedOnSides(EnumSet.of(this.getUp(), this.getUp().method_10153()));
        super.onReady();
    }

    @Override
    public boolean isPowered() {
        if (!this.isClientSide()) {
            return this.getMainNode().isPowered() || this.storedPower > 0.0f;
        }
        return this.hasPower;
    }

    @Override
    public boolean isActive() {
        return this.isPowered();
    }

    private void setPowered(boolean hasPower) {
        this.hasPower = hasPower;
    }

    @Nullable
    public ICrankable getCrankable(class_2350 direction) {
        if (direction == this.getUp() || direction == this.getUp().method_10153()) {
            return new Crankable();
        }
        return null;
    }

    class Crankable
    implements ICrankable {
        Crankable() {
        }

        @Override
        public boolean canTurn() {
            return QuartzGrowthAcceleratorBlockEntity.this.storedPower < 1600.0f;
        }

        @Override
        public void applyTurn() {
            if (QuartzGrowthAcceleratorBlockEntity.this.isClientSide()) {
                return;
            }
            boolean needsUpdate = !QuartzGrowthAcceleratorBlockEntity.this.isPowered();
            QuartzGrowthAcceleratorBlockEntity.this.storedPower = Math.min(1600.0f, QuartzGrowthAcceleratorBlockEntity.this.storedPower + 160.0f);
            if (needsUpdate) {
                QuartzGrowthAcceleratorBlockEntity.this.markForUpdate();
            }
        }
    }
}

