/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.compiler.IdUtils;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.FlowTagCompiler;
import appeng.client.guidebook.document.block.LytImage;
import appeng.client.guidebook.document.flow.InlineBlockAlignment;
import appeng.client.guidebook.document.flow.LytFlowInlineBlock;
import appeng.client.guidebook.document.flow.LytFlowParent;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.libs.mdast.model.MdAstNode;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatingImageCompiler
extends FlowTagCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FloatingImageCompiler.class);

    @Override
    protected void compile(PageCompiler compiler, LytFlowParent parent, MdxJsxElementFields el) {
        String src = el.getAttributeString("src", null);
        String align = el.getAttributeString("align", "left");
        String title = el.getAttributeString("title", null);
        LytImage image = new LytImage();
        if (title != null) {
            image.setTitle(title);
        }
        try {
            class_2960 imageId = IdUtils.resolveLink(src, compiler.getId());
            byte[] imageContent = compiler.loadAsset(imageId);
            if (imageContent == null) {
                LOGGER.error("Couldn't find image {}", (Object)src);
                image.setTitle("Missing image: " + src);
            }
            image.setImage(imageId, imageContent);
        }
        catch (class_151 e) {
            LOGGER.error("Invalid image id: {}", (Object)src);
            image.setTitle("Invalid image URL: " + src);
        }
        LytFlowInlineBlock inlineBlock = new LytFlowInlineBlock();
        inlineBlock.setBlock(image);
        switch (align) {
            case "left": {
                inlineBlock.setAlignment(InlineBlockAlignment.FLOAT_LEFT);
                image.setMarginRight(5);
                image.setMarginBottom(5);
                break;
            }
            case "right": {
                inlineBlock.setAlignment(InlineBlockAlignment.FLOAT_RIGHT);
                image.setMarginLeft(5);
                image.setMarginBottom(5);
                break;
            }
            default: {
                parent.append(compiler.createErrorFlowContent("Invalid align. Must be left or right.", (MdAstNode)((Object)el)));
                return;
            }
        }
        parent.append(inlineBlock);
    }
}

