/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.layout.flow;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.document.flow.LytFlowSpan;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.flow.Line;
import appeng.client.guidebook.layout.flow.LineBlock;
import appeng.client.guidebook.layout.flow.LineBuilder;
import appeng.client.guidebook.layout.flow.LineElement;
import appeng.client.guidebook.render.RenderContext;
import appeng.client.guidebook.style.TextAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

public class FlowBuilder {
    private final List<Line> lines = new ArrayList<Line>();
    private final List<LytFlowContent> rootContent = new ArrayList<LytFlowContent>();
    private final List<LineBlock> floats = new ArrayList<LineBlock>();

    public void append(LytFlowContent content) {
        this.rootContent.add(content);
    }

    public LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth, TextAlignment alignment) {
        this.lines.clear();
        this.floats.clear();
        LineBuilder lineBuilder = new LineBuilder(context, x, y, availableWidth, this.lines, this.floats, alignment);
        for (LytFlowContent content : this.rootContent) {
            this.visitInDocumentOrder(content, lineBuilder);
        }
        lineBuilder.end();
        return lineBuilder.getBounds();
    }

    public void renderBatch(RenderContext context, class_4597 buffers, @Nullable LytFlowContent hoveredContent) {
        for (Line line : this.lines) {
            LineElement el = line.firstElement();
            while (el != null) {
                el.containsMouse = hoveredContent != null && hoveredContent.isInclusiveAncestor(el.getFlowContent());
                el.renderBatch(context, buffers);
                el = el.next;
            }
        }
    }

    public void renderFloatsBatch(RenderContext context, class_4597 buffers, @Nullable LytFlowContent hoveredContent) {
        for (Line line : this.lines) {
            LineElement el = line.firstElement();
            while (el != null) {
                el.containsMouse = hoveredContent != null && hoveredContent.isInclusiveAncestor(el.getFlowContent());
                el.renderBatch(context, buffers);
                el = el.next;
            }
        }
    }

    public void render(RenderContext context, @Nullable LytFlowContent hoveredContent) {
        for (Line line : this.lines) {
            LineElement el = line.firstElement();
            while (el != null) {
                el.containsMouse = hoveredContent != null && hoveredContent.isInclusiveAncestor(el.getFlowContent());
                el.render(context);
                el = el.next;
            }
        }
    }

    public void renderFloats(RenderContext context, @Nullable LytFlowContent hoveredContent) {
        for (LineBlock el : this.floats) {
            el.containsMouse = hoveredContent != null && hoveredContent.isInclusiveAncestor(el.getFlowContent());
            el.render(context);
        }
    }

    private void visitInDocumentOrder(LytFlowContent content, Consumer<LytFlowContent> visitor) {
        if (content instanceof LytFlowSpan) {
            LytFlowSpan flowSpan = (LytFlowSpan)content;
            for (LytFlowContent child : flowSpan.getChildren()) {
                this.visitInDocumentOrder(child, visitor);
            }
        } else {
            visitor.accept(content);
        }
    }

    @Nullable
    public LineElement pick(int x, int y) {
        LineBlock floatEl = this.pickFloatingElement(x, y);
        if (floatEl != null) {
            return floatEl;
        }
        for (Line line : this.lines) {
            if (!line.bounds().contains(x, y)) continue;
            LineElement el = line.firstElement();
            while (el != null) {
                if (el.bounds.contains(x, y)) {
                    return el;
                }
                el = el.next;
            }
        }
        return null;
    }

    public Stream<LytRect> enumerateContentBounds(LytFlowContent content) {
        return Stream.concat(this.lines.stream().flatMap(Line::elements), this.floats.stream()).filter(el -> el.getFlowContent() == content).map(el -> el.bounds);
    }

    @Nullable
    public LineBlock pickFloatingElement(int x, int y) {
        for (LineBlock el : this.floats) {
            if (!el.bounds.contains(x, y)) continue;
            return el;
        }
        return null;
    }

    public boolean floatsIntersect(LytRect bounds) {
        for (LineBlock el : this.floats) {
            if (!el.bounds.intersects(bounds)) continue;
            return true;
        }
        return false;
    }
}

