/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.navigation;

import appeng.client.guidebook.compiler.FrontmatterNavigation;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.navigation.NavigationNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigationTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(NavigationTree.class);
    private final Map<class_2960, NavigationNode> nodeIndex;
    private final List<NavigationNode> rootNodes;
    private static final Comparator<NavigationNode> NODE_COMPARATOR = Comparator.comparingInt(NavigationNode::position).thenComparing(NavigationNode::title);

    public NavigationTree(Map<class_2960, NavigationNode> nodeIndex, List<NavigationNode> rootNodes) {
        this.nodeIndex = nodeIndex;
        this.rootNodes = rootNodes;
    }

    public NavigationTree() {
        this.nodeIndex = Map.of();
        this.rootNodes = List.of();
    }

    public List<NavigationNode> getRootNodes() {
        return this.rootNodes;
    }

    @Nullable
    public NavigationNode getNodeById(class_2960 pageId) {
        return this.nodeIndex.get(pageId);
    }

    public static NavigationTree build(Collection<ParsedGuidePage> pages) {
        HashMap<class_2960, Pair<ParsedGuidePage, List<ParsedGuidePage>>> pagesWithChildren = new HashMap<class_2960, Pair<ParsedGuidePage, List<ParsedGuidePage>>>();
        for (ParsedGuidePage page : pages) {
            FrontmatterNavigation navigationEntry = page.getFrontmatter().navigationEntry();
            if (navigationEntry == null) continue;
            pagesWithChildren.compute(page.getId(), (resourceLocation, previousPair) -> previousPair != null ? Pair.of((Object)page, (Object)((List)previousPair.getRight())) : Pair.of((Object)page, new ArrayList()));
            class_2960 parentId = navigationEntry.parent();
            if (parentId == null) continue;
            pagesWithChildren.compute(parentId, (resourceLocation, prevPage) -> {
                if (prevPage != null) {
                    ((List)prevPage.getRight()).add(page);
                    return prevPage;
                }
                ArrayList<ParsedGuidePage> children = new ArrayList<ParsedGuidePage>();
                children.add(page);
                return Pair.of(null, children);
            });
        }
        HashMap<class_2960, NavigationNode> nodeIndex = new HashMap<class_2960, NavigationNode>(pages.size());
        ArrayList<NavigationNode> rootNodes = new ArrayList<NavigationNode>();
        for (Map.Entry entry : pagesWithChildren.entrySet()) {
            NavigationTree.createNode(nodeIndex, rootNodes, pagesWithChildren, (class_2960)entry.getKey(), (Pair<ParsedGuidePage, List<ParsedGuidePage>>)((Pair)entry.getValue()));
        }
        rootNodes.sort(NODE_COMPARATOR);
        return new NavigationTree(Map.copyOf(nodeIndex), List.copyOf(rootNodes));
    }

    private static NavigationNode createNode(HashMap<class_2960, NavigationNode> nodeIndex, ArrayList<NavigationNode> rootNodes, Map<class_2960, Pair<ParsedGuidePage, List<ParsedGuidePage>>> pagesWithChildren, class_2960 pageId, Pair<ParsedGuidePage, List<ParsedGuidePage>> entry) {
        ParsedGuidePage page = (ParsedGuidePage)entry.getKey();
        List children = (List)entry.getRight();
        if (page == null) {
            LOGGER.error("Pages {} had unknown navigation parent {}", (Object)children, (Object)pageId);
            return null;
        }
        FrontmatterNavigation navigationEntry = Objects.requireNonNull(page.getFrontmatter().navigationEntry(), "navigation frontmatter");
        class_1799 icon = class_1799.field_8037;
        if (navigationEntry.iconItemId() != null) {
            class_1792 iconItem = (class_1792)class_2378.field_11142.method_10223(navigationEntry.iconItemId());
            icon = new class_1799((class_1935)iconItem);
            icon.method_7980(navigationEntry.iconNbt());
            if (icon.method_7960()) {
                LOGGER.error("Couldn't find icon {} for icon of page {}", (Object)navigationEntry.iconItemId(), (Object)page);
            }
        }
        ArrayList<NavigationNode> childNodes = new ArrayList<NavigationNode>(children.size());
        for (ParsedGuidePage childPage : children) {
            Pair<ParsedGuidePage, List<ParsedGuidePage>> childPageEntry = pagesWithChildren.get(childPage.getId());
            childNodes.add(NavigationTree.createNode(nodeIndex, rootNodes, pagesWithChildren, childPage.getId(), childPageEntry));
        }
        childNodes.sort(NODE_COMPARATOR);
        NavigationNode node = new NavigationNode(page.getId(), navigationEntry.title(), icon, childNodes, navigationEntry.position(), true);
        nodeIndex.put(page.getId(), node);
        if (navigationEntry.parent() == null) {
            rootNodes.add(node);
        }
        return node;
    }
}

