/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.parts.PartHelper;
import appeng.api.util.AEAxisAlignedBB;
import appeng.block.networking.CableBusBlock;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.FacadeBlockAccess;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.client.render.cablebus.QuadRotator;
import appeng.parts.misc.CableAnchorPart;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadClamper;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadCornerKicker;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadFaceStripper;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadReInterpolator;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadTinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_325;
import net.minecraft.class_3665;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_777;

public class FacadeBuilder {
    private final Renderer renderer = RendererAccess.INSTANCE.getRenderer();
    public static final double THIN_THICKNESS = 0.0625;
    public static final double THICK_THICKNESS = 0.125;
    public static final class_238[] THICK_FACADE_BOXES = new class_238[]{new class_238(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new class_238(0.0, 0.875, 0.0, 1.0, 1.0, 1.0), new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 0.125), new class_238(0.0, 0.0, 0.875, 1.0, 1.0, 1.0), new class_238(0.0, 0.0, 0.0, 0.125, 1.0, 1.0), new class_238(0.875, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final class_238[] THIN_FACADE_BOXES = new class_238[]{new class_238(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), new class_238(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0), new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625), new class_238(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0), new class_238(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0), new class_238(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private final Map<class_2350, Mesh> transparentFacadeQuads;
    private final Map<class_2350, Mesh> cableAnchorStilts;

    public FacadeBuilder(class_1088 modelLoader, @Nullable class_1087 transparentFacadeModel) {
        this.cableAnchorStilts = this.buildCableAnchorStems(modelLoader);
        this.transparentFacadeQuads = new EnumMap<class_2350, Mesh>(class_2350.class);
        if (transparentFacadeModel != null) {
            List partQuads = transparentFacadeModel.method_4707(null, null, class_5819.method_43047());
            for (class_2350 facing : class_2350.values()) {
                MeshBuilder meshBuilder = this.renderer.meshBuilder();
                QuadEmitter emitter = meshBuilder.getEmitter();
                RenderContext.QuadTransform rotator = QuadRotator.get(facing, class_2350.field_11036);
                for (class_777 quad : partQuads) {
                    emitter.fromVanilla(quad.method_3357(), 0, false);
                    emitter.cullFace(null);
                    emitter.nominalFace(quad.method_3358());
                    if (!rotator.transform((MutableQuadView)emitter)) continue;
                    emitter.emit();
                }
                this.transparentFacadeQuads.put(facing, meshBuilder.build());
            }
        } else {
            for (class_2350 facing : class_2350.values()) {
                this.transparentFacadeQuads.put(facing, this.renderer.meshBuilder().build());
            }
        }
    }

    private Map<class_2350, Mesh> buildCableAnchorStems(class_1088 modelLoader) {
        EnumMap<class_2350, Mesh> stems = new EnumMap<class_2350, Mesh>(class_2350.class);
        ArrayList<class_1087> cableAnchorParts = new ArrayList<class_1087>();
        for (class_2960 model : CableAnchorPart.FACADE_MODELS.getModels()) {
            class_1087 cableAnchor = modelLoader.method_15878(model, (class_3665)class_1086.field_5350);
            cableAnchorParts.add(cableAnchor);
        }
        for (class_2350 side : class_2350.values()) {
            RenderContext.QuadTransform rotator = QuadRotator.get(side, class_2350.field_11036);
            MeshBuilder meshBuilder = this.renderer.meshBuilder();
            QuadEmitter emitter = meshBuilder.getEmitter();
            for (class_1087 model : cableAnchorParts) {
                for (int cullFaceIdx = 0; cullFaceIdx <= 6; ++cullFaceIdx) {
                    class_2350 cullFace = ModelHelper.faceFromIndex((int)cullFaceIdx);
                    List quads = model.method_4707(null, cullFace, class_5819.method_43047());
                    for (class_777 quad : quads) {
                        emitter.fromVanilla(quad.method_3357(), 0, false);
                        emitter.cullFace(cullFace);
                        emitter.nominalFace(quad.method_3358());
                        if (!rotator.transform((MutableQuadView)emitter)) continue;
                        emitter.emit();
                    }
                }
            }
            stems.put(side, meshBuilder.build());
        }
        return stems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mesh getFacadeMesh(CableBusRenderState renderState, Supplier<class_5819> rand, class_1920 level, RenderContext context) {
        boolean transparent = PartHelper.getCableRenderMode().transparentFacades;
        EnumMap<class_2350, FacadeRenderState> facadeStates = renderState.getFacades();
        List<class_238> partBoxes = renderState.getBoundingBoxes();
        Set<class_2350> sidesWithParts = renderState.getAttachments().keySet();
        class_2338 pos = renderState.getPos();
        class_324 blockColors = class_310.method_1551().method_1505();
        boolean thinFacades = FacadeBuilder.isUseThinFacades(partBoxes);
        MeshBuilder meshBuilder = this.renderer.meshBuilder();
        QuadEmitter emitter = meshBuilder.getEmitter();
        for (Map.Entry entry : facadeStates.entrySet()) {
            class_238 fullBounds;
            boolean renderStilt;
            class_2350 side = (class_2350)entry.getKey();
            int sideIndex = side.ordinal();
            FacadeRenderState facadeRenderState = (FacadeRenderState)entry.getValue();
            boolean bl = renderStilt = !sidesWithParts.contains(side);
            if (renderStilt) {
                this.cableAnchorStilts.get(side).forEach(quad -> {
                    quad.copyTo((MutableQuadView)emitter);
                    emitter.emit();
                });
            }
            if (transparent) {
                this.transparentFacadeQuads.get(side).forEach(quad -> {
                    quad.copyTo((MutableQuadView)emitter);
                    emitter.emit();
                });
                continue;
            }
            class_2680 blockState = facadeRenderState.getSourceBlock();
            class_238 facadeBox = fullBounds = thinFacades ? THIN_FACADE_BOXES[sideIndex] : THICK_FACADE_BOXES[sideIndex];
            if (facadeRenderState.isTransparent()) {
                double offset = thinFacades ? 0.0625 : 0.125;
                AEAxisAlignedBB tmpBB = null;
                block12: for (class_2350 face : class_2350.values()) {
                    FacadeRenderState otherState;
                    if (face.method_10166() == side.method_10166() || (otherState = (FacadeRenderState)facadeStates.get(face)) == null || otherState.isTransparent()) continue;
                    if (tmpBB == null) {
                        tmpBB = AEAxisAlignedBB.fromBounds(facadeBox);
                    }
                    switch (face) {
                        case field_11033: {
                            tmpBB.minY += offset;
                            continue block12;
                        }
                        case field_11036: {
                            tmpBB.maxY -= offset;
                            continue block12;
                        }
                        case field_11043: {
                            tmpBB.minZ += offset;
                            continue block12;
                        }
                        case field_11035: {
                            tmpBB.maxZ -= offset;
                            continue block12;
                        }
                        case field_11039: {
                            tmpBB.minX += offset;
                            continue block12;
                        }
                        case field_11034: {
                            tmpBB.maxX -= offset;
                            continue block12;
                        }
                        default: {
                            throw new RuntimeException("Switch falloff. " + String.valueOf(face));
                        }
                    }
                }
                if (tmpBB != null) {
                    facadeBox = tmpBB.getBoundingBox();
                }
            }
            int facadeMask = 0;
            for (Map.Entry ent : facadeStates.entrySet()) {
                FacadeRenderState otherState;
                class_2350 s = (class_2350)ent.getKey();
                if (s.method_10166() == side.method_10166() || (otherState = (FacadeRenderState)ent.getValue()).isTransparent()) continue;
                facadeMask |= 1 << s.ordinal();
            }
            AEAxisAlignedBB cutOutBox = FacadeBuilder.getCutOutBox(facadeBox, partBoxes);
            List<class_238> holeStrips = FacadeBuilder.getBoxes(facadeBox, cutOutBox, side.method_10166());
            FacadeBlockAccess facadeAccess = new FacadeBlockAccess(level, pos, side, blockState);
            class_776 dispatcher = class_310.method_1551().method_1541();
            FabricBakedModel model = (FabricBakedModel)dispatcher.method_3349(blockState);
            QuadFaceStripper faceStripper = new QuadFaceStripper(fullBounds, facadeMask);
            QuadCornerKicker kicker = new QuadCornerKicker();
            kicker.setSide(sideIndex);
            kicker.setFacadeMask(facadeMask);
            kicker.setBox(fullBounds);
            kicker.setThickness(thinFacades ? 0.0625 : 0.125);
            QuadReInterpolator interpolator = new QuadReInterpolator();
            CableBusBlock.RENDERING_FACADE_DIRECTION.set(side);
            try {
                context.pushTransform(quad -> {
                    class_2338 adjPos;
                    class_2680 adjState;
                    class_2350 cullFace = quad.cullFace();
                    QuadTinter quadTinter = null;
                    if (cullFace != null && blockState.method_26187(adjState = level.method_8320(adjPos = pos.method_10093(cullFace)).getAppearance(level, adjPos, cullFace.method_10153(), blockState, pos), cullFace)) {
                        return false;
                    }
                    if (quad.colorIndex() != -1) {
                        quadTinter = new QuadTinter(blockColors.method_1697(blockState, (class_1920)facadeAccess, pos, quad.colorIndex()));
                    }
                    for (class_238 box : holeStrips) {
                        quad.copyTo((MutableQuadView)emitter);
                        emitter.cullFace((class_2350)(cullFace == side ? side : null));
                        emitter.nominalFace(quad.lightFace());
                        interpolator.setInputQuad((QuadView)emitter);
                        QuadClamper clamper = new QuadClamper(box);
                        if (!clamper.transform((MutableQuadView)emitter) || !faceStripper.transform((MutableQuadView)emitter) || !kicker.transform((MutableQuadView)emitter)) continue;
                        interpolator.transform((MutableQuadView)emitter);
                        if (quadTinter != null) {
                            quadTinter.transform((MutableQuadView)emitter);
                        }
                        emitter.emit();
                    }
                    return false;
                });
                model.emitBlockQuads(level, blockState, pos, rand, context);
                context.popTransform();
            }
            finally {
                CableBusBlock.RENDERING_FACADE_DIRECTION.set(null);
            }
        }
        return meshBuilder.build();
    }

    public Mesh buildFacadeItemQuads(class_1799 textureItem, class_2350 side) {
        MeshBuilder meshBuilder = this.renderer.meshBuilder();
        QuadEmitter emitter = meshBuilder.getEmitter();
        class_1087 model = class_310.method_1551().method_1480().method_4019(textureItem, null, null, 0);
        QuadReInterpolator interpolator = new QuadReInterpolator();
        class_325 itemColors = class_310.method_1551().field_1760;
        QuadClamper clamper = new QuadClamper(THICK_FACADE_BOXES[side.ordinal()]);
        for (int cullFaceIdx = 0; cullFaceIdx <= 6; ++cullFaceIdx) {
            class_2350 cullFace = ModelHelper.faceFromIndex((int)cullFaceIdx);
            List quads = model.method_4707(null, cullFace, class_5819.method_43047());
            for (class_777 quad : quads) {
                QuadTinter quadTinter = null;
                if (quad.method_3359() != -1) {
                    quadTinter = new QuadTinter(itemColors.method_1704(textureItem, quad.method_3359()));
                }
                emitter.fromVanilla(quad.method_3357(), 0, false);
                emitter.cullFace(cullFace);
                emitter.nominalFace(quad.method_3358());
                interpolator.setInputQuad((QuadView)emitter);
                if (!clamper.transform((MutableQuadView)emitter)) continue;
                interpolator.transform((MutableQuadView)emitter);
                if (quadTinter != null) {
                    quadTinter.transform((MutableQuadView)emitter);
                }
                emitter.emit();
            }
        }
        return meshBuilder.build();
    }

    @Nullable
    private static AEAxisAlignedBB getCutOutBox(class_238 facadeBox, List<class_238> partBoxes) {
        AEAxisAlignedBB b = null;
        for (class_238 bb : partBoxes) {
            if (!bb.method_994(facadeBox)) continue;
            if (b == null) {
                b = AEAxisAlignedBB.fromBounds(bb);
                continue;
            }
            b.maxX = Math.max(b.maxX, bb.field_1320);
            b.maxY = Math.max(b.maxY, bb.field_1325);
            b.maxZ = Math.max(b.maxZ, bb.field_1324);
            b.minX = Math.min(b.minX, bb.field_1323);
            b.minY = Math.min(b.minY, bb.field_1322);
            b.minZ = Math.min(b.minZ, bb.field_1321);
        }
        return b;
    }

    private static List<class_238> getBoxes(class_238 fb, AEAxisAlignedBB hole, class_2350.class_2351 axis) {
        if (hole == null) {
            return Collections.singletonList(fb);
        }
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        switch (axis) {
            case field_11052: {
                boxes.add(new class_238(fb.field_1323, fb.field_1322, fb.field_1321, hole.minX, fb.field_1325, fb.field_1324));
                boxes.add(new class_238(hole.maxX, fb.field_1322, fb.field_1321, fb.field_1320, fb.field_1325, fb.field_1324));
                boxes.add(new class_238(hole.minX, fb.field_1322, fb.field_1321, hole.maxX, fb.field_1325, hole.minZ));
                boxes.add(new class_238(hole.minX, fb.field_1322, hole.maxZ, hole.maxX, fb.field_1325, fb.field_1324));
                break;
            }
            case field_11051: {
                boxes.add(new class_238(fb.field_1323, fb.field_1322, fb.field_1321, fb.field_1320, hole.minY, fb.field_1324));
                boxes.add(new class_238(fb.field_1323, hole.maxY, fb.field_1321, fb.field_1320, fb.field_1325, fb.field_1324));
                boxes.add(new class_238(fb.field_1323, hole.minY, fb.field_1321, hole.minX, hole.maxY, fb.field_1324));
                boxes.add(new class_238(hole.maxX, hole.minY, fb.field_1321, fb.field_1320, hole.maxY, fb.field_1324));
                break;
            }
            case field_11048: {
                boxes.add(new class_238(fb.field_1323, fb.field_1322, fb.field_1321, fb.field_1320, hole.minY, fb.field_1324));
                boxes.add(new class_238(fb.field_1323, hole.maxY, fb.field_1321, fb.field_1320, fb.field_1325, fb.field_1324));
                boxes.add(new class_238(fb.field_1323, hole.minY, fb.field_1321, fb.field_1320, hole.maxY, hole.minZ));
                boxes.add(new class_238(fb.field_1323, hole.minY, hole.maxZ, fb.field_1320, hole.maxY, fb.field_1324));
                break;
            }
            default: {
                throw new RuntimeException("switch falloff. " + String.valueOf(axis));
            }
        }
        return boxes;
    }

    private static boolean isUseThinFacades(List<class_238> partBoxes) {
        double min = 0.125;
        double max = 0.875;
        for (class_238 bb : partBoxes) {
            int o = 0;
            o += bb.field_1320 > 0.875 ? 1 : 0;
            o += bb.field_1325 > 0.875 ? 1 : 0;
            o += bb.field_1324 > 0.875 ? 1 : 0;
            o += bb.field_1323 < 0.125 ? 1 : 0;
            o += bb.field_1322 < 0.125 ? 1 : 0;
            if ((o += bb.field_1321 < 0.125 ? 1 : 0) < 2) continue;
            return true;
        }
        return false;
    }
}

