/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.block.crafting.CraftingUnitType;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.LightBakedModel;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.crafting.UnitBakedModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_2960;
import net.minecraft.class_4730;

public class CraftingUnitModelProvider
extends AbstractCraftingUnitModelProvider<CraftingUnitType> {
    private static final List<class_4730> MATERIALS = new ArrayList<class_4730>();
    protected static final class_4730 RING_CORNER = CraftingUnitModelProvider.texture("ring_corner");
    protected static final class_4730 RING_SIDE_HOR = CraftingUnitModelProvider.texture("ring_side_hor");
    protected static final class_4730 RING_SIDE_VER = CraftingUnitModelProvider.texture("ring_side_ver");
    protected static final class_4730 UNIT_BASE = CraftingUnitModelProvider.texture("unit_base");
    protected static final class_4730 LIGHT_BASE = CraftingUnitModelProvider.texture("light_base");
    protected static final class_4730 ACCELERATOR_LIGHT = CraftingUnitModelProvider.texture("accelerator_light");
    protected static final class_4730 STORAGE_1K_LIGHT = CraftingUnitModelProvider.texture("1k_storage_light");
    protected static final class_4730 STORAGE_4K_LIGHT = CraftingUnitModelProvider.texture("4k_storage_light");
    protected static final class_4730 STORAGE_16K_LIGHT = CraftingUnitModelProvider.texture("16k_storage_light");
    protected static final class_4730 STORAGE_64K_LIGHT = CraftingUnitModelProvider.texture("64k_storage_light");
    protected static final class_4730 STORAGE_256K_LIGHT = CraftingUnitModelProvider.texture("256k_storage_light");
    protected static final class_4730 MONITOR_BASE = CraftingUnitModelProvider.texture("monitor_base");
    protected static final class_4730 MONITOR_LIGHT_DARK = CraftingUnitModelProvider.texture("monitor_light_dark");
    protected static final class_4730 MONITOR_LIGHT_MEDIUM = CraftingUnitModelProvider.texture("monitor_light_medium");
    protected static final class_4730 MONITOR_LIGHT_BRIGHT = CraftingUnitModelProvider.texture("monitor_light_bright");

    public CraftingUnitModelProvider(CraftingUnitType type) {
        super(type);
    }

    @Override
    public List<class_4730> getMaterials() {
        return Collections.unmodifiableList(MATERIALS);
    }

    public class_1058 getLightMaterial(Function<class_4730, class_1058> textureGetter) {
        return switch ((CraftingUnitType)this.type) {
            case CraftingUnitType.ACCELERATOR -> textureGetter.apply(ACCELERATOR_LIGHT);
            case CraftingUnitType.STORAGE_1K -> textureGetter.apply(STORAGE_1K_LIGHT);
            case CraftingUnitType.STORAGE_4K -> textureGetter.apply(STORAGE_4K_LIGHT);
            case CraftingUnitType.STORAGE_16K -> textureGetter.apply(STORAGE_16K_LIGHT);
            case CraftingUnitType.STORAGE_64K -> textureGetter.apply(STORAGE_64K_LIGHT);
            case CraftingUnitType.STORAGE_256K -> textureGetter.apply(STORAGE_256K_LIGHT);
            default -> throw new IllegalArgumentException("Crafting unit type " + this.type + " does not use a light texture.");
        };
    }

    @Override
    public class_1087 getBakedModel(Function<class_4730, class_1058> spriteGetter) {
        class_1058 ringCorner = spriteGetter.apply(RING_CORNER);
        class_1058 ringSideHor = spriteGetter.apply(RING_SIDE_HOR);
        class_1058 ringSideVer = spriteGetter.apply(RING_SIDE_VER);
        return switch ((CraftingUnitType)this.type) {
            default -> throw new IncompatibleClassChangeError();
            case CraftingUnitType.UNIT -> new UnitBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(UNIT_BASE));
            case CraftingUnitType.ACCELERATOR, CraftingUnitType.STORAGE_1K, CraftingUnitType.STORAGE_4K, CraftingUnitType.STORAGE_16K, CraftingUnitType.STORAGE_64K, CraftingUnitType.STORAGE_256K -> new LightBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(LIGHT_BASE), this.getLightMaterial(spriteGetter));
            case CraftingUnitType.MONITOR -> new MonitorBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(UNIT_BASE), spriteGetter.apply(MONITOR_BASE), spriteGetter.apply(MONITOR_LIGHT_DARK), spriteGetter.apply(MONITOR_LIGHT_MEDIUM), spriteGetter.apply(MONITOR_LIGHT_BRIGHT));
        };
    }

    private static class_4730 texture(String name) {
        class_4730 mat = new class_4730(class_1059.field_5275, new class_2960("ae2", "block/crafting/" + name));
        MATERIALS.add(mat);
        return mat;
    }
}

