/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.RenderHelper;
import appeng.decorative.solid.GlassState;
import appeng.decorative.solid.QuartzGlassBlock;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;

class GlassBakedModel
implements class_1087,
FabricBakedModel {
    private static final byte[][][] OFFSETS = GlassBakedModel.generateOffsets();
    static final class_4730 TEXTURE_A = new class_4730(class_1059.field_5275, new class_2960("ae2:block/glass/quartz_glass_a"));
    static final class_4730 TEXTURE_B = new class_4730(class_1059.field_5275, new class_2960("ae2:block/glass/quartz_glass_b"));
    static final class_4730 TEXTURE_C = new class_4730(class_1059.field_5275, new class_2960("ae2:block/glass/quartz_glass_c"));
    static final class_4730 TEXTURE_D = new class_4730(class_1059.field_5275, new class_2960("ae2:block/glass/quartz_glass_d"));
    static final class_4730[] TEXTURES_FRAME = GlassBakedModel.generateTexturesFrame();
    private final RenderMaterial material = RendererAccess.INSTANCE.getRenderer().materialFinder().disableDiffuse(0, true).disableAo(0, true).disableColorIndex(0, true).blendMode(0, BlendMode.TRANSLUCENT).find();
    private final class_1058[] glassTextures;
    private final class_1058[] frameTextures;

    private static class_4730[] generateTexturesFrame() {
        return (class_4730[])IntStream.range(1, 16).mapToObj(Integer::toBinaryString).map(s -> Strings.padStart((String)s, (int)4, (char)'0')).map(s -> new class_2960("ae2:block/glass/quartz_glass_frame" + s)).map(rl -> new class_4730(class_1059.field_5275, rl)).toArray(class_4730[]::new);
    }

    public GlassBakedModel(Function<class_4730, class_1058> bakedTextureGetter) {
        this.glassTextures = new class_1058[]{bakedTextureGetter.apply(TEXTURE_A), bakedTextureGetter.apply(TEXTURE_B), bakedTextureGetter.apply(TEXTURE_C), bakedTextureGetter.apply(TEXTURE_D)};
        this.frameTextures = new class_1058[16];
        for (int i = 0; i < TEXTURES_FRAME.length; ++i) {
            this.frameTextures[1 + i] = bakedTextureGetter.apply(TEXTURES_FRAME[i]);
        }
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        GlassState glassState = GlassBakedModel.getGlassState(blockView, state, pos);
        int cx = Math.abs(glassState.getX() % 10);
        int cy = Math.abs(glassState.getY() % 10);
        int cz = Math.abs(glassState.getZ() % 10);
        int u = OFFSETS[cx][cy][cz] % 4;
        int v = OFFSETS[9 - cx][9 - cy][9 - cz] % 4;
        int texIdx = Math.abs((OFFSETS[cx][cy][cz] + (glassState.getX() + glassState.getY() + glassState.getZ())) % 4);
        if (texIdx < 2) {
            u /= 2;
            v /= 2;
        }
        class_1058 glassTexture = this.glassTextures[texIdx];
        QuadEmitter emitter = context.getEmitter();
        for (class_2350 side : class_2350.values()) {
            if (glassState.hasAdjacentGlassBlock(side)) continue;
            List<class_1160> corners = RenderHelper.getFaceCorners(side);
            this.emitQuad(emitter, side, corners, glassTexture, u, v);
            int edgeBitmask = glassState.getMask(side);
            class_1058 sideSprite = this.frameTextures[edgeBitmask];
            if (sideSprite == null) continue;
            this.emitQuad(emitter, side, corners, sideSprite, 0.0f, 0.0f);
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 face, class_5819 random) {
        return Collections.emptyList();
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public boolean method_24304() {
        return false;
    }

    private static int makeBitmask(class_1920 level, class_2680 state, class_2338 pos, class_2350 side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> GlassBakedModel.makeBitmask(level, state, pos, side, class_2350.field_11035, class_2350.field_11034, class_2350.field_11043, class_2350.field_11039);
            case class_2350.field_11036 -> GlassBakedModel.makeBitmask(level, state, pos, side, class_2350.field_11035, class_2350.field_11039, class_2350.field_11043, class_2350.field_11034);
            case class_2350.field_11043 -> GlassBakedModel.makeBitmask(level, state, pos, side, class_2350.field_11036, class_2350.field_11039, class_2350.field_11033, class_2350.field_11034);
            case class_2350.field_11035 -> GlassBakedModel.makeBitmask(level, state, pos, side, class_2350.field_11036, class_2350.field_11034, class_2350.field_11033, class_2350.field_11039);
            case class_2350.field_11039 -> GlassBakedModel.makeBitmask(level, state, pos, side, class_2350.field_11036, class_2350.field_11035, class_2350.field_11033, class_2350.field_11043);
            case class_2350.field_11034 -> GlassBakedModel.makeBitmask(level, state, pos, side, class_2350.field_11036, class_2350.field_11043, class_2350.field_11033, class_2350.field_11035);
        };
    }

    private static int makeBitmask(class_1920 level, class_2680 state, class_2338 pos, class_2350 face, class_2350 up, class_2350 right, class_2350 down, class_2350 left) {
        int bitmask = 0;
        if (!GlassBakedModel.isGlassBlock(level, state, pos, face, up)) {
            bitmask |= 1;
        }
        if (!GlassBakedModel.isGlassBlock(level, state, pos, face, right)) {
            bitmask |= 2;
        }
        if (!GlassBakedModel.isGlassBlock(level, state, pos, face, down)) {
            bitmask |= 4;
        }
        if (!GlassBakedModel.isGlassBlock(level, state, pos, face, left)) {
            bitmask |= 8;
        }
        return bitmask;
    }

    private void emitQuad(QuadEmitter emitter, class_2350 side, List<class_1160> corners, class_1058 sprite, float uOffset, float vOffset) {
        this.emitQuad(emitter, side, corners.get(0), corners.get(1), corners.get(2), corners.get(3), sprite, uOffset, vOffset);
    }

    private void emitQuad(QuadEmitter emitter, class_2350 side, class_1160 c1, class_1160 c2, class_1160 c3, class_1160 c4, class_1058 sprite, float uOffset, float vOffset) {
        float u1 = sprite.method_4580((double)class_3532.method_15363((float)(0.0f - uOffset), (float)0.0f, (float)16.0f));
        float u2 = sprite.method_4580((double)class_3532.method_15363((float)(16.0f - uOffset), (float)0.0f, (float)16.0f));
        float v1 = sprite.method_4570((double)class_3532.method_15363((float)(0.0f - vOffset), (float)0.0f, (float)16.0f));
        float v2 = sprite.method_4570((double)class_3532.method_15363((float)(16.0f - vOffset), (float)0.0f, (float)16.0f));
        emitter.nominalFace(side);
        emitter.cullFace(side);
        emitter.material(this.material);
        emitter.pos(0, c1).sprite(0, 0, u1, v1);
        emitter.pos(1, c2).sprite(1, 0, u1, v2);
        emitter.pos(2, c3).sprite(2, 0, u2, v2);
        emitter.pos(3, c4).sprite(3, 0, u2, v1);
        emitter.spriteColor(0, -1, -1, -1, -1);
        emitter.emit();
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public boolean method_4708() {
        return false;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.frameTextures[this.frameTextures.length - 1];
    }

    private static byte[][][] generateOffsets() {
        Random r = new Random(924L);
        byte[][][] offset = new byte[10][10][10];
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                r.nextBytes(offset[x][y]);
            }
        }
        return offset;
    }

    private static GlassState getGlassState(class_1920 level, class_2680 state, class_2338 pos) {
        int[] masks = new int[6];
        for (class_2350 facing : class_2350.values()) {
            masks[facing.method_10146()] = GlassBakedModel.makeBitmask(level, state, pos, facing);
        }
        boolean[] adjacentGlassBlocks = new boolean[6];
        for (class_2350 facing : class_2350.values()) {
            adjacentGlassBlocks[facing.method_10146()] = GlassBakedModel.isGlassBlock(level, state, pos, facing.method_10153(), facing);
        }
        return new GlassState(pos.method_10263(), pos.method_10264(), pos.method_10260(), masks, adjacentGlassBlocks);
    }

    private static boolean isGlassBlock(class_1920 level, class_2680 state, class_2338 pos, class_2350 face, class_2350 adjDir) {
        class_2338 adjacentPos = pos.method_10093(adjDir);
        return level.method_8320(adjacentPos).getAppearance(level, adjacentPos, face, state, pos).method_26204() instanceof QuartzGlassBlock;
    }
}

