/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.storage.cells.CellState;
import java.util.EnumMap;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4668;

class CellLedRenderer {
    private static final EnumMap<CellState, class_1160> STATE_COLORS;
    private static final class_1160 UNPOWERED_COLOR;
    private static final class_1160 BLINK_COLOR;
    private static final float L = 0.3125f;
    private static final float R = 0.25f;
    private static final float T = 0.0625f;
    private static final float B = -6.25E-5f;
    private static final float FR = -6.25E-5f;
    private static final float BA = 0.0311875f;
    private static final float[] LED_QUADS;
    public static final class_1921 RENDER_LAYER;

    public static void renderLed(IChestOrDrive drive, int slot, class_4588 buffer, class_4587 ms, float partialTicks) {
        class_1160 color = CellLedRenderer.getColorForSlot(drive, slot, partialTicks);
        if (color == null) {
            return;
        }
        for (int i = 0; i < LED_QUADS.length; i += 3) {
            float x = LED_QUADS[i];
            float y = LED_QUADS[i + 1];
            float z = LED_QUADS[i + 2];
            buffer.method_22918(ms.method_23760().method_23761(), x, y, z).method_22915(color.method_4943(), color.method_4945(), color.method_4947(), 1.0f).method_1344();
        }
    }

    private static class_1160 getColorForSlot(IChestOrDrive drive, int slot, float partialTicks) {
        CellState state = drive.getCellStatus(slot);
        if (state == CellState.ABSENT) {
            return null;
        }
        if (!drive.isPowered()) {
            return UNPOWERED_COLOR;
        }
        class_1160 col = STATE_COLORS.get((Object)state);
        if (drive.isCellBlinking(slot)) {
            long t = System.currentTimeMillis() % 200L;
            float f = (float)(t - 100L) / 200.0f + 0.5f;
            f = CellLedRenderer.easeInOutCubic(f);
            col = col.method_23850();
            col.method_23847(BLINK_COLOR, f);
        }
        return col;
    }

    private static float easeInOutCubic(float x) {
        return x < 0.5f ? 4.0f * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0f;
    }

    private CellLedRenderer() {
    }

    static {
        UNPOWERED_COLOR = new class_1160(0.0f, 0.0f, 0.0f);
        BLINK_COLOR = new class_1160(1.0f, 0.5f, 0.5f);
        STATE_COLORS = new EnumMap(CellState.class);
        for (CellState cellState : CellState.values()) {
            int color = cellState.getStateColor();
            class_1160 colorVector = new class_1160((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            STATE_COLORS.put(cellState, colorVector);
        }
        LED_QUADS = new float[]{0.25f, 0.0625f, -6.25E-5f, 0.3125f, 0.0625f, -6.25E-5f, 0.3125f, -6.25E-5f, -6.25E-5f, 0.25f, -6.25E-5f, -6.25E-5f, 0.3125f, 0.0625f, -6.25E-5f, 0.3125f, 0.0625f, 0.0311875f, 0.3125f, -6.25E-5f, 0.0311875f, 0.3125f, -6.25E-5f, -6.25E-5f, 0.25f, 0.0625f, 0.0311875f, 0.25f, 0.0625f, -6.25E-5f, 0.25f, -6.25E-5f, -6.25E-5f, 0.25f, -6.25E-5f, 0.0311875f, 0.25f, 0.0625f, 0.0311875f, 0.3125f, 0.0625f, 0.0311875f, 0.3125f, 0.0625f, -6.25E-5f, 0.25f, 0.0625f, -6.25E-5f, 0.25f, -6.25E-5f, -6.25E-5f, 0.3125f, -6.25E-5f, -6.25E-5f, 0.3125f, -6.25E-5f, 0.0311875f, 0.25f, -6.25E-5f, 0.0311875f};
        RENDER_LAYER = class_1921.method_24049((String)"ae_drive_leds", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27382, (int)32565, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_29442).method_23617(false));
    }
}

