/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.IAEAddonEntrypoint;
import appeng.api.parts.CableRenderMode;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.CreativeTab;
import appeng.core.FacadeCreativeTab;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.network.ServerNetworkHandler;
import appeng.hooks.ToolItemHook;
import appeng.hooks.WrenchHook;
import appeng.hooks.ticking.TickHandler;
import appeng.init.InitApiLookup;
import appeng.init.InitBlockEntities;
import appeng.init.InitBlocks;
import appeng.init.InitDispenserBehavior;
import appeng.init.InitEntityTypes;
import appeng.init.InitItems;
import appeng.init.InitMenuTypes;
import appeng.init.InitRecipeSerializers;
import appeng.init.InitVillager;
import appeng.init.client.InitKeyTypes;
import appeng.init.client.InitParticleTypes;
import appeng.init.internal.InitGridLinkables;
import appeng.init.internal.InitP2PAttunements;
import appeng.init.internal.InitStorageCells;
import appeng.init.internal.InitUpgrades;
import appeng.init.worldgen.InitBiomes;
import appeng.init.worldgen.InitDimensionTypes;
import appeng.init.worldgen.InitStructures;
import appeng.items.tools.NetworkToolItem;
import appeng.server.AECommand;
import appeng.server.services.ChunkLoadingService;
import appeng.server.testworld.GameTestPlotAdapter;
import appeng.spatial.SpatialStorageChunkGenerator;
import appeng.spatial.SpatialStorageDimensionIds;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_4519;
import net.minecraft.class_5458;
import net.minecraft.class_7151;
import net.minecraft.server.MinecraftServer;

public abstract class AppEngBase
implements AppEng {
    private final ThreadLocal<class_1657> partInteractionPlayer = new ThreadLocal();
    static AppEngBase INSTANCE;
    private MinecraftServer currentServer;

    public AppEngBase() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
        AEConfig.load(FabricLoader.getInstance().getConfigDir());
        InitKeyTypes.init();
        CreativeTab.init();
        AEItems.init();
        AEBlocks.init();
        AEParts.init();
        InitGridLinkables.init();
        InitStorageCells.init();
        InitVillager.init();
        FacadeCreativeTab.init();
        this.registerDimension();
        this.registerBiomes((class_2378<class_1959>)class_5458.field_25933);
        this.registerBlocks((class_2378<class_2248>)class_2378.field_11146);
        this.registerItems((class_2378<class_1792>)class_2378.field_11142);
        this.registerEntities((class_2378<class_1299<?>>)class_2378.field_11145);
        this.registerParticleTypes(class_2378.field_11141);
        this.registerBlockEntities(class_2378.field_11137);
        this.registerMenuTypes(class_2378.field_17429);
        this.registerRecipeSerializers(class_2378.field_17598);
        this.registerStructures(class_2378.field_16644);
        this.postRegistrationInitialization();
        TickHandler.instance().init();
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerAboutToStart);
        ServerLifecycleEvents.SERVER_STOPPED.register(this::serverStopped);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::serverStopping);
        ServerLifecycleEvents.SERVER_STARTING.register(this::registerCommands);
        UseBlockCallback.EVENT.register(WrenchHook::onPlayerUseBlock);
        UseBlockCallback.EVENT.register(ToolItemHook::onPlayerUseBlock);
    }

    public void postRegistrationInitialization() {
        InitP2PAttunements.init();
        InitApiLookup.init();
        InitDispenserBehavior.init();
        AEConfig.instance().save();
        InitUpgrades.init();
        this.initNetworkHandler();
    }

    protected void initNetworkHandler() {
        new ServerNetworkHandler();
    }

    public void registerBiomes(class_2378<class_1959> registry) {
        InitBiomes.init(registry);
    }

    public void registerBlocks(class_2378<class_2248> registry) {
        InitBlocks.init(registry);
    }

    public void registerItems(class_2378<class_1792> registry) {
        InitItems.init(registry);
    }

    public void registerBlockEntities(class_2378<class_2591<?>> registry) {
        InitBlockEntities.init(registry);
    }

    public void registerMenuTypes(class_2378<class_3917<?>> registry) {
        InitMenuTypes.init(registry);
    }

    public void registerRecipeSerializers(class_2378<class_1865<?>> registry) {
        InitRecipeSerializers.init(registry);
    }

    public void registerEntities(class_2378<class_1299<?>> registry) {
        InitEntityTypes.init(registry);
    }

    public void registerParticleTypes(class_2378<class_2396<?>> registry) {
        InitParticleTypes.init(registry);
    }

    public void registerDimensionType() {
        InitDimensionTypes.init();
    }

    public void registerStructures(class_2378<class_7151<?>> registry) {
        InitStructures.init();
    }

    public void registerCommands(MinecraftServer server) {
        CommandDispatcher dispatcher = server.method_3734().method_9235();
        new AECommand().register((CommandDispatcher<class_2168>)dispatcher);
    }

    public void registerDimension() {
        InitDimensionTypes.init();
        class_2378.method_10230((class_2378)class_2378.field_25097, (class_2960)SpatialStorageDimensionIds.CHUNK_GENERATOR_ID, SpatialStorageChunkGenerator.CODEC);
    }

    private void onServerAboutToStart(MinecraftServer server) {
        this.currentServer = server;
        ChunkLoadingService.getInstance().onServerAboutToStart();
    }

    private void serverStopping(MinecraftServer server) {
        ChunkLoadingService.getInstance().onServerStopping();
    }

    private void serverStopped(MinecraftServer server) {
        TickHandler.instance().shutdown();
        if (this.currentServer == server) {
            this.currentServer = null;
        }
    }

    @Override
    public Collection<class_3222> getPlayers() {
        MinecraftServer server = this.getCurrentServer();
        if (server != null) {
            return server.method_3760().method_14571();
        }
        return Collections.emptyList();
    }

    @Override
    public void sendToAllNearExcept(class_1657 p, double x, double y, double z, double dist, class_1937 level, BasePacket packet) {
        if (level.method_8608()) {
            return;
        }
        for (class_3222 o : this.getPlayers()) {
            double dZ;
            double dY;
            double dX;
            if (o == p || o.field_6002 != level || !((dX = x - o.method_23317()) * dX + (dY = y - o.method_23318()) * dY + (dZ = z - o.method_23321()) * dZ < dist * dist)) continue;
            NetworkHandler.instance().sendTo(packet, o);
        }
    }

    @Override
    public void setPartInteractionPlayer(class_1657 player) {
        this.partInteractionPlayer.set(player);
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        return this.getCableRenderModeForPlayer(this.partInteractionPlayer.get());
    }

    @Override
    @Nullable
    public MinecraftServer getCurrentServer() {
        return this.currentServer;
    }

    protected final CableRenderMode getCableRenderModeForPlayer(@Nullable class_1657 player) {
        if (player != null) {
            for (int x = 0; x < class_1661.method_7368(); ++x) {
                class_2487 c;
                class_1799 is = player.method_31548().method_5438(x);
                if (is.method_7960() || !(is.method_7909() instanceof NetworkToolItem) || (c = is.method_7969()) == null || !c.method_10577("hideFacades")) continue;
                return CableRenderMode.CABLE_VIEW;
            }
        }
        return CableRenderMode.STANDARD;
    }

    protected final void notifyAddons(String sideSpecificEntrypoint) {
        List entrypoints = FabricLoader.getInstance().getEntrypoints("ae2", IAEAddonEntrypoint.class);
        for (IAEAddonEntrypoint entrypoint : entrypoints) {
            entrypoint.onAe2Initialized();
        }
        List sideSpecificEntrypoints = FabricLoader.getInstance().getEntrypoints("ae2:" + sideSpecificEntrypoint, IAEAddonEntrypoint.class);
        for (IAEAddonEntrypoint entrypoint : sideSpecificEntrypoints) {
            entrypoint.onAe2Initialized();
        }
    }

    protected static void registerTests() {
        if ("true".equals(System.getProperty("appeng.tests"))) {
            class_4519.method_36068(GameTestPlotAdapter.class);
        }
    }
}

