/*
 * Decompiled with CFR 0.152.
 */
package appeng.facade;

import appeng.api.implementations.items.IFacadeItem;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.core.definitions.AEItems;
import appeng.items.parts.FacadeItem;
import appeng.parts.CableBusStorage;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.apache.commons.lang3.StringUtils;

public class FacadeContainer
implements IFacadeContainer {
    private static final String[] NBT_KEY_NAMES = (String[])Arrays.stream(class_2350.values()).map(d -> "facade" + StringUtils.capitalize((String)d.method_15434())).toArray(String[]::new);
    private static final String[] NBT_KEY_OLD_NAMES = (String[])Arrays.stream(class_2350.values()).map(d -> "facade:" + d.ordinal()).toArray(String[]::new);
    private final CableBusStorage storage;
    private final Consumer<class_2350> changeCallback;

    public FacadeContainer(CableBusStorage cbs, Consumer<class_2350> changeCallback) {
        this.storage = cbs;
        this.changeCallback = changeCallback;
    }

    @Override
    public boolean canAddFacade(IFacadePart a) {
        return this.getFacade(a.getSide()) == null;
    }

    @Override
    public boolean addFacade(IFacadePart a) {
        if (this.canAddFacade(a)) {
            this.storage.setFacade(a.getSide(), a);
            this.notifyChange(a.getSide());
            return true;
        }
        return false;
    }

    @Override
    public void removeFacade(IPartHost host, class_2350 side) {
        if (side != null && this.storage.getFacade(side) != null) {
            this.storage.removeFacade(side);
            this.notifyChange(side);
            if (host != null) {
                host.markForUpdate();
            }
        }
    }

    @Override
    public IFacadePart getFacade(class_2350 side) {
        return this.storage.getFacade(side);
    }

    @Override
    public void readFromNBT(class_2487 c) {
        for (class_2350 side : class_2350.values()) {
            class_1792 class_17922;
            class_2487 facadeTag;
            class_1799 is;
            this.storage.removeFacade(side);
            class_2520 tag = c.method_10580(NBT_KEY_NAMES[side.ordinal()]);
            if (tag == null) {
                tag = c.method_10580(NBT_KEY_OLD_NAMES[side.ordinal()]);
            }
            if (!(tag instanceof class_2487) || (is = class_1799.method_7915((class_2487)(facadeTag = (class_2487)tag))).method_7960() || !((class_17922 = is.method_7909()) instanceof IFacadeItem)) continue;
            IFacadeItem facadeItem = (IFacadeItem)class_17922;
            this.storage.setFacade(side, facadeItem.createPartFromItemStack(is, side));
        }
    }

    @Override
    public void writeToNBT(class_2487 c) {
        for (class_2350 side : class_2350.values()) {
            if (this.storage.getFacade(side) == null) continue;
            class_2487 data = new class_2487();
            this.storage.getFacade(side).getItemStack().method_7953(data);
            c.method_10566(NBT_KEY_NAMES[side.ordinal()], (class_2520)data);
        }
    }

    @Override
    public boolean readFromStream(class_2540 out) {
        byte facadeSides = out.readByte();
        boolean changed = false;
        for (class_2350 side : class_2350.values()) {
            int ix = 1 << side.ordinal();
            if ((facadeSides & ix) == ix) {
                int id = out.method_10816();
                FacadeItem ifa = AEItems.FACADE.method_8389();
                class_1799 facade = ifa.createFromID(id);
                if (facade == null) continue;
                changed = changed || this.storage.getFacade(side) == null;
                this.storage.setFacade(side, ifa.createPartFromItemStack(facade, side));
                continue;
            }
            changed = changed || this.storage.getFacade(side) != null;
            this.storage.removeFacade(side);
        }
        return changed;
    }

    @Override
    public void writeToStream(class_2540 out) {
        int facadeSides = 0;
        for (class_2350 side : class_2350.values()) {
            if (this.getFacade(side) == null) continue;
            facadeSides |= 1 << side.ordinal();
        }
        out.writeByte((int)((byte)facadeSides));
        for (class_2350 side : class_2350.values()) {
            IFacadePart part = this.getFacade(side);
            if (part == null) continue;
            int itemID = class_1792.method_7880((class_1792)part.getItem());
            out.method_10804(itemID);
        }
    }

    @Override
    public boolean isEmpty() {
        for (class_2350 side : class_2350.values()) {
            if (this.storage.getFacade(side) == null) continue;
            return false;
        }
        return true;
    }

    private void notifyChange(class_2350 side) {
        this.changeCallback.accept(side);
    }
}

