/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.igtooltip.parts;

import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.api.networking.IGridNode;
import appeng.api.networking.pathing.ControllerState;
import appeng.core.localization.InGameTooltip;
import appeng.me.service.AdHocNetworkError;
import appeng.me.service.PathingService;
import appeng.parts.networking.IUsedChannelProvider;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class ChannelDataProvider
implements BodyProvider<IUsedChannelProvider>,
ServerDataProvider<IUsedChannelProvider> {
    private static final String TAG_MAX_CHANNELS = "maxChannels";
    private static final String TAG_USED_CHANNELS = "usedChannels";
    private static final String TAG_ERROR = "channelError";

    @Override
    public void buildTooltip(IUsedChannelProvider object, TooltipContext context, TooltipBuilder tooltip) {
        class_2487 serverData = context.serverData();
        if (serverData.method_10573(TAG_ERROR, 8)) {
            ChannelError error = ChannelError.valueOf(serverData.method_10558(TAG_ERROR));
            tooltip.addLine((class_2561)error.text.text().method_27692(class_124.field_1061));
            return;
        }
        if (serverData.method_10573(TAG_MAX_CHANNELS, 3)) {
            int usedChannels = serverData.method_10550(TAG_USED_CHANNELS);
            int maxChannels = serverData.method_10550(TAG_MAX_CHANNELS);
            if (maxChannels <= 0) {
                tooltip.addLine((class_2561)InGameTooltip.Channels.text(usedChannels));
            } else {
                tooltip.addLine((class_2561)InGameTooltip.ChannelsOf.text(usedChannels, maxChannels));
            }
        }
    }

    @Override
    public void provideServerData(class_3222 player, IUsedChannelProvider object, class_2487 serverData) {
        IGridNode gridNode = object.getGridNode();
        if (gridNode != null) {
            PathingService pathingService = (PathingService)gridNode.getGrid().getPathingService();
            if (pathingService.getControllerState() == ControllerState.NO_CONTROLLER) {
                AdHocNetworkError adHocError = pathingService.getAdHocNetworkError();
                if (adHocError != null) {
                    serverData.method_10582(TAG_ERROR, switch (adHocError) {
                        default -> throw new IncompatibleClassChangeError();
                        case AdHocNetworkError.NESTED_P2P_TUNNEL -> ChannelError.AD_HOC_NESTED_P2P_TUNNEL.name();
                        case AdHocNetworkError.TOO_MANY_CHANNELS -> ChannelError.AD_HOC_TOO_MANY_CHANNELS.name();
                    });
                    return;
                }
            } else if (pathingService.getControllerState() == ControllerState.CONTROLLER_CONFLICT) {
                serverData.method_10582(TAG_ERROR, ChannelError.CONTROLLER_CONFLICT.name());
            }
        }
        serverData.method_10569(TAG_USED_CHANNELS, object.getUsedChannelsInfo());
        serverData.method_10569(TAG_MAX_CHANNELS, object.getMaxChannelsInfo());
    }

    static enum ChannelError {
        AD_HOC_NESTED_P2P_TUNNEL(InGameTooltip.ErrorNestedP2PTunnel),
        AD_HOC_TOO_MANY_CHANNELS(InGameTooltip.ErrorTooManyChannels),
        CONTROLLER_CONFLICT(InGameTooltip.ErrorControllerConflict);

        final InGameTooltip text;

        private ChannelError(InGameTooltip text) {
            this.text = text;
        }
    }
}

