/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.transfer;

import appeng.core.localization.ItemModText;
import appeng.integration.modules.jei.JEIPlugin;
import appeng.integration.modules.jei.transfer.AbstractTransferHandler;
import appeng.integration.modules.jeirei.CompatLayerHelper;
import appeng.integration.modules.jeirei.CraftingHelper;
import appeng.integration.modules.jeirei.TransferHelper;
import appeng.menu.me.items.CraftingTermMenu;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4587;
import net.minecraft.class_465;

public class UseCraftingRecipeTransfer<T extends CraftingTermMenu>
extends AbstractTransferHandler
implements IRecipeTransferHandler<T, class_3955> {
    private final Class<T> menuClass;
    private final class_3917<T> menuType;
    private final IRecipeTransferHandlerHelper helper;

    public UseCraftingRecipeTransfer(Class<T> menuClass, class_3917<T> menuType, IRecipeTransferHandlerHelper helper) {
        this.menuClass = menuClass;
        this.menuType = menuType;
        this.helper = helper;
    }

    public IRecipeTransferError transferRecipe(T menu, class_3955 recipe, IRecipeSlotsView display, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        if (recipe.method_17716() != class_3956.field_17545) {
            return this.helper.createInternalError();
        }
        if (recipe.method_8117().isEmpty()) {
            return this.helper.createUserErrorWithTooltip((class_2561)ItemModText.INCOMPATIBLE_RECIPE.text());
        }
        if (!recipe.method_8113(3, 3)) {
            return this.helper.createUserErrorWithTooltip((class_2561)ItemModText.RECIPE_TOO_LARGE.text());
        }
        boolean craftMissing = class_465.method_25441();
        List inputSlots = display.getSlotViews(RecipeIngredientRole.INPUT);
        Map<Integer, class_1856> slotToIngredientMap = UseCraftingRecipeTransfer.getGuiSlotToIngredientMap(recipe);
        CraftingTermMenu.MissingIngredientSlots missingSlots = ((CraftingTermMenu)menu).findMissingIngredients(slotToIngredientMap);
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            List<IRecipeSlotView> missingSlotViews = missingSlots.missingSlots().stream().map(idx -> idx < inputSlots.size() ? (IRecipeSlotView)inputSlots.get((int)idx) : null).filter(Objects::nonNull).toList();
            return this.helper.createUserErrorForMissingSlots((class_2561)ItemModText.NO_ITEMS.text(), missingSlotViews);
        }
        if (!doTransfer) {
            if (missingSlots.totalSize() != 0) {
                int color = missingSlots.anyMissing() ? -2130729728 : -2142943745;
                return new ErrorRenderer(missingSlots, craftMissing, color);
            }
        } else {
            CraftingHelper.performTransfer(menu, recipe, craftMissing);
        }
        return null;
    }

    private static Map<Integer, class_1856> getGuiSlotToIngredientMap(class_1860<?> recipe) {
        int height;
        int width;
        if (CompatLayerHelper.IS_LOADED) {
            return appeng.integration.modules.rei.transfer.UseCraftingRecipeTransfer.getGuiSlotToIngredientMap(recipe);
        }
        class_2371 ingredients = recipe.method_8117();
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            width = shapedRecipe.method_8150();
            height = shapedRecipe.method_8158();
        } else if (ingredients.size() > 4) {
            height = 3;
            width = 3;
        } else if (ingredients.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        LinkedHashMap<Integer, class_1856> result = new LinkedHashMap<Integer, class_1856>(ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            int guiSlot = UseCraftingRecipeTransfer.getCraftingIndex(i, width, height);
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8103()) continue;
            result.put(guiSlot, ingredient);
        }
        return result;
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    public Class<T> getContainerClass() {
        return this.menuClass;
    }

    public Optional<class_3917<T>> getMenuType() {
        return Optional.of(this.menuType);
    }

    public RecipeType<class_3955> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    private record ErrorRenderer(CraftingTermMenu.MissingIngredientSlots indices, boolean craftMissing, int color) implements IRecipeTransferError
    {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public int getButtonHighlightColor() {
            return this.color;
        }

        public void showError(class_4587 poseStack, int mouseX, int mouseY, IRecipeSlotsView slots, int recipeX, int recipeY) {
            poseStack.method_22903();
            poseStack.method_22904((double)recipeX, (double)recipeY, 0.0);
            List slotViews = slots.getSlotViews(RecipeIngredientRole.INPUT);
            for (int i = 0; i < slotViews.size(); ++i) {
                IRecipeSlotView slotView = (IRecipeSlotView)slotViews.get(i);
                boolean missing = this.indices.missingSlots().contains(i);
                boolean craftable = this.indices.craftableSlots().contains(i);
                if (!missing && !craftable) continue;
                slotView.drawHighlight(poseStack, missing ? 0x66FF0000 : 0x400000FF);
            }
            poseStack.method_22909();
            List<class_2561> tooltip = TransferHelper.createCraftingTooltip(this.indices, this.craftMissing);
            JEIPlugin.drawHoveringText(poseStack, tooltip, mouseX, mouseY);
        }
    }
}

