/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.wthit;

import appeng.api.integrations.igtooltip.ClientRegistration;
import appeng.api.integrations.igtooltip.CommonRegistration;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.IconProvider;
import appeng.api.integrations.igtooltip.providers.ModNameProvider;
import appeng.api.integrations.igtooltip.providers.NameProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.integration.modules.igtooltip.TooltipProviders;
import appeng.integration.modules.wthit.WthitTooltipBuilder;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class WthitModule
implements IWailaPlugin {
    public void register(final IRegistrar registrar) {
        TooltipProviders.loadCommon(new CommonRegistration(){

            @Override
            public <T extends class_2586> void addBlockEntityData(Class<T> blockEntityClass, ServerDataProvider<? super T> provider) {
                registrar.addBlockData((data, accessor, config) -> {
                    class_2586 obj = (class_2586)blockEntityClass.cast(accessor.getTarget());
                    provider.provideServerData(accessor.getPlayer(), obj, data);
                }, blockEntityClass);
            }
        });
        TooltipProviders.loadClient(new ClientRegistration(){

            @Override
            public <T extends class_2586> void addBlockEntityBody(final Class<T> blockEntityClass, Class<? extends class_2248> blockClass, class_2960 id, final BodyProvider<? super T> provider, int priority) {
                registrar.addComponent(new IBlockComponentProvider(){

                    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
                        class_2586 be = (class_2586)blockEntityClass.cast(accessor.getBlockEntity());
                        TooltipContext context = WthitModule.getContext(accessor);
                        provider.buildTooltip(be, context, new WthitTooltipBuilder(tooltip));
                    }
                }, TooltipPosition.BODY, blockEntityClass, priority);
            }

            @Override
            public <T extends class_2586> void addBlockEntityIcon(final Class<T> blockEntityClass, Class<? extends class_2248> blockClass, class_2960 id, final IconProvider<? super T> provider, int priority) {
                registrar.addIcon(new IBlockComponentProvider(){

                    @Nullable
                    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
                        TooltipContext context;
                        class_2586 be = (class_2586)blockEntityClass.cast(accessor.getBlockEntity());
                        class_1799 icon = provider.getIcon(be, context = WthitModule.getContext(accessor));
                        return icon != null ? new ItemComponent(icon) : null;
                    }
                }, blockClass, priority);
            }

            @Override
            public <T extends class_2586> void addBlockEntityName(final Class<T> blockEntityClass, Class<? extends class_2248> blockClass, class_2960 id, final NameProvider<? super T> provider, int priority) {
                registrar.addComponent(new IBlockComponentProvider(){

                    public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
                        TooltipContext context;
                        class_2586 obj = (class_2586)blockEntityClass.cast(accessor.getBlockEntity());
                        class_2561 name = provider.getName(obj, context = WthitModule.getContext(accessor));
                        if (name != null) {
                            tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, (class_2561)name.method_27661().method_27694(style -> {
                                if (style.method_10973() == null) {
                                    return style.method_10977(class_124.field_1068);
                                }
                                return style;
                            }));
                        }
                    }
                }, TooltipPosition.HEAD, blockEntityClass, priority);
            }

            @Override
            public <T extends class_2586> void addBlockEntityModName(final Class<T> blockEntityClass, Class<? extends class_2248> blockClass, class_2960 id, final ModNameProvider<? super T> provider, int priority) {
                registrar.addComponent(new IBlockComponentProvider(){

                    public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
                        TooltipContext context;
                        class_2586 obj = (class_2586)blockEntityClass.cast(accessor.getBlockEntity());
                        String modName = provider.getModName(obj, context = WthitModule.getContext(accessor));
                        if (modName != null && tooltip.getLine(WailaConstants.MOD_NAME_TAG) != null) {
                            tooltip.setLine(WailaConstants.MOD_NAME_TAG, (class_2561)class_2561.method_43470((String)modName).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}));
                        }
                    }
                }, TooltipPosition.TAIL, blockEntityClass, priority);
            }
        });
    }

    private static TooltipContext getContext(IBlockAccessor accessor) {
        return new TooltipContext(accessor.getServerData(), accessor.getHitResult().method_17784(), accessor.getPlayer());
    }
}

