/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.exceptions.SecurityConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.util.AEColor;
import appeng.core.AELog;
import appeng.hooks.ticking.TickHandler;
import appeng.me.GridConnection;
import appeng.me.GridNode;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3218;

public class InWorldGridNode
extends GridNode {
    private final class_2338 location;

    public <T> InWorldGridNode(class_3218 level, class_2338 location, T owner, IGridNodeListener<T> listener, Set<GridFlags> flags) {
        super(level, owner, listener, flags);
        this.location = location;
    }

    @Override
    protected void findInWorldConnections() {
        GridNode adjacentNode;
        EnumSet<class_2350> newSecurityConnections = EnumSet.noneOf(class_2350.class);
        this.cleanupConnections();
        class_2338.class_2339 pos = new class_2338.class_2339();
        block0: for (class_2350 direction : this.exposedOnSides) {
            pos.method_25505((class_2382)this.location, direction);
            adjacentNode = (GridNode)GridHelper.getExposedNode((class_1937)this.getLevel(), (class_2338)pos, direction.method_10153());
            if (adjacentNode == null || !this.hasCompatibleColor(adjacentNode)) continue;
            for (GridConnection c : this.connections) {
                if (!c.isInWorld() || c.getDirection(this) != direction) continue;
                IGridNode os = c.getOtherSide(this);
                if (os == adjacentNode) continue block0;
                AELog.warn("Grid node %s did not disconnect properly and is now replaced with %s", os, adjacentNode);
                c.destroy();
                break;
            }
            if (adjacentNode.getLastSecurityKey() != -1L) {
                newSecurityConnections.add(direction);
                continue;
            }
            if (this.connectTo(direction, adjacentNode)) continue;
            return;
        }
        for (class_2350 direction : newSecurityConnections) {
            pos.method_25505((class_2382)this.location, direction);
            adjacentNode = (GridNode)GridHelper.getExposedNode((class_1937)this.getLevel(), (class_2338)pos, direction.method_10153());
            if (adjacentNode == null || this.connectTo(direction, adjacentNode)) continue;
            return;
        }
    }

    @Override
    public String toString() {
        return super.toString() + " @ " + this.location.method_10263() + "," + this.location.method_10264() + "," + this.location.method_10260();
    }

    private void cleanupConnections() {
        for (IGridConnection connection : this.getConnections()) {
            if (!connection.isInWorld()) continue;
            class_2350 ourSide = connection.getDirection(this);
            if (!this.isExposedOnSide(ourSide)) {
                connection.destroy();
                continue;
            }
            class_2350 theirSide = ourSide.method_10153();
            IGridNode otherNode = connection.getOtherSide(this);
            if (otherNode.isExposedOnSide(theirSide) && this.hasCompatibleColor(otherNode)) continue;
            connection.destroy();
        }
    }

    private boolean hasCompatibleColor(IGridNode otherNode) {
        AEColor ourColor = this.getGridColor();
        AEColor theirColor = otherNode.getGridColor();
        return ourColor == AEColor.TRANSPARENT || theirColor == AEColor.TRANSPARENT || ourColor == theirColor;
    }

    private boolean connectTo(class_2350 direction, IGridNode adjacentNode) {
        try {
            GridConnection.create(adjacentNode, this, direction.method_10153());
            return true;
        }
        catch (SecurityConnectionException e) {
            AELog.debug(e);
            TickHandler.instance().addCallable((class_1936)adjacentNode.getLevel(), () -> this.callListener(IGridNodeListener::onSecurityBreak));
            return false;
        }
        catch (FailedConnectionException e) {
            AELog.debug(e);
            return false;
        }
    }

    public class_2338 getLocation() {
        return this.location;
    }
}

