/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityService;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.localization.GuiText;
import appeng.me.service.SecurityService;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.class_2561;

public class NetworkStorage
implements MEStorage {
    private static final ThreadLocal<Deque<NetworkStorage>> DEPTH_MOD = new ThreadLocal();
    private static final ThreadLocal<Deque<NetworkStorage>> DEPTH_SIM = new ThreadLocal();
    private static final Comparator<Integer> PRIORITY_SORTER = (o1, o2) -> Integer.compare(o2, o1);
    private boolean mountsInUse;
    private static int currentPass = 0;
    private final SecurityService security;
    private final NavigableMap<Integer, List<MEStorage>> priorityInventory;
    private final List<MEStorage> secondPassInventories = new ArrayList<MEStorage>();
    private int myPass = 0;
    @Nullable
    private List<QueuedOperation> queuedOperations;

    public NetworkStorage(SecurityService security) {
        this.security = security;
        this.priorityInventory = new TreeMap<Integer, List<MEStorage>>(PRIORITY_SORTER);
    }

    public void mount(int priority, MEStorage inventory) {
        if (this.mountsInUse) {
            if (this.queuedOperations == null) {
                this.queuedOperations = new ArrayList<QueuedOperation>();
            }
            this.queuedOperations.add(new MountOperation(priority, inventory));
        } else {
            this.priorityInventory.computeIfAbsent(priority, k -> new ArrayList()).add(inventory);
        }
    }

    public void unmount(MEStorage inventory) {
        if (this.mountsInUse) {
            if (this.queuedOperations == null) {
                this.queuedOperations = new ArrayList<QueuedOperation>();
            }
            this.queuedOperations.add(new UnmountOperation(inventory));
        } else {
            Iterator prioIt = this.priorityInventory.entrySet().iterator();
            while (prioIt.hasNext()) {
                Map.Entry prioEntry = prioIt.next();
                List inventories = (List)prioEntry.getValue();
                if (!inventories.remove(inventory) || !inventories.isEmpty()) continue;
                prioIt.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(AEKey what, long amount, Actionable type, IActionSource src) {
        if (this.diveList(type)) {
            return 0L;
        }
        if (this.isPermissionDenied(src, SecurityPermissions.INJECT)) {
            this.surface(type);
            return 0L;
        }
        long remaining = amount;
        this.mountsInUse = true;
        try {
            block3: for (List invList : this.priorityInventory.values()) {
                this.secondPassInventories.clear();
                Iterator ii = invList.iterator();
                while (ii.hasNext() && remaining > 0L) {
                    MEStorage inv = (MEStorage)ii.next();
                    if (this.isQueuedForRemoval(inv)) continue;
                    if (inv.isPreferredStorageFor(what, src)) {
                        remaining -= inv.insert(what, remaining, type, src);
                        continue;
                    }
                    this.secondPassInventories.add(inv);
                }
                for (MEStorage inv : this.secondPassInventories) {
                    if (remaining <= 0L) continue block3;
                    if (this.isQueuedForRemoval(inv)) continue;
                    remaining -= inv.insert(what, remaining, type, src);
                }
            }
        }
        finally {
            this.mountsInUse = false;
        }
        this.surface(type);
        this.flushQueuedOperations();
        return amount - remaining;
    }

    private void flushQueuedOperations() {
        Preconditions.checkState((!this.mountsInUse ? 1 : 0) != 0);
        List<QueuedOperation> queuedOperations = this.queuedOperations;
        if (queuedOperations != null) {
            this.queuedOperations = null;
            for (QueuedOperation op : queuedOperations) {
                if (op instanceof MountOperation) {
                    MountOperation mountOp = (MountOperation)op;
                    this.mount(mountOp.priority, mountOp.storage);
                    continue;
                }
                if (op instanceof UnmountOperation) {
                    UnmountOperation unmountOp = (UnmountOperation)op;
                    this.unmount(unmountOp.storage);
                    continue;
                }
                throw new IllegalStateException("Unknown operation: " + op);
            }
        }
    }

    private boolean isQueuedForRemoval(MEStorage inv) {
        if (this.queuedOperations != null) {
            for (QueuedOperation queuedOperation : this.queuedOperations) {
                if (!(queuedOperation instanceof UnmountOperation)) continue;
                UnmountOperation unmountOperation = (UnmountOperation)queuedOperation;
                if (unmountOperation.storage != inv) continue;
                return true;
            }
        }
        return false;
    }

    private boolean diveList(Actionable type) {
        Deque<NetworkStorage> cDepth = this.getDepth(type);
        if (cDepth.contains(this)) {
            return true;
        }
        cDepth.push(this);
        return false;
    }

    private boolean isPermissionDenied(IActionSource src, SecurityPermissions permission) {
        if (src.player().isPresent()) {
            if (!this.security.hasPermission(src.player().get(), permission)) {
                return true;
            }
        } else if (src.machine().isPresent() && this.security.isAvailable()) {
            IGridNode sourceNode = src.machine().get().getActionableNode();
            if (sourceNode == null) {
                return true;
            }
            IGrid sourceGrid = sourceNode.getGrid();
            if (sourceGrid != this.security.getGrid()) {
                int playerID;
                ISecurityService sg = sourceGrid.getSecurityService();
                int n = playerID = sg.isAvailable() ? sg.getOwner() : sourceNode.getOwningPlayerId();
                if (!this.security.hasPermission(playerID, permission)) {
                    return true;
                }
            }
        }
        return false;
    }

    private void surface(Actionable type) {
        if (this.getDepth(type).pop() != this) {
            throw new IllegalStateException("Invalid Access to Networked Storage API detected.");
        }
    }

    private Deque<NetworkStorage> getDepth(Actionable type) {
        ThreadLocal<Deque<NetworkStorage>> depth = type == Actionable.MODULATE ? DEPTH_MOD : DEPTH_SIM;
        Deque<NetworkStorage> s = depth.get();
        if (s == null) {
            s = new ArrayDeque<NetworkStorage>();
            depth.set(s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.diveList(mode)) {
            return 0L;
        }
        if (this.isPermissionDenied(source, SecurityPermissions.EXTRACT)) {
            this.surface(mode);
            return 0L;
        }
        long extracted = 0L;
        this.mountsInUse = true;
        try {
            for (List invList : this.priorityInventory.descendingMap().values()) {
                Iterator ii = invList.iterator();
                while (ii.hasNext() && extracted < amount) {
                    MEStorage inv = (MEStorage)ii.next();
                    if (this.isQueuedForRemoval(inv)) continue;
                    extracted += inv.extract(what, amount - extracted, mode, source);
                }
            }
        }
        finally {
            this.mountsInUse = false;
        }
        this.surface(mode);
        this.flushQueuedOperations();
        return extracted;
    }

    @Override
    public void getAvailableStacks(KeyCounter out) {
        if (this.diveIteration(Actionable.SIMULATE)) {
            return;
        }
        for (List i : this.priorityInventory.values()) {
            for (MEStorage j : i) {
                j.getAvailableStacks(out);
            }
        }
        this.surface(Actionable.SIMULATE);
    }

    private boolean diveIteration(Actionable type) {
        Deque<NetworkStorage> cDepth = this.getDepth(type);
        if (cDepth.isEmpty()) {
            ++currentPass;
        } else if (currentPass == this.myPass) {
            return true;
        }
        this.myPass = currentPass;
        cDepth.push(this);
        return false;
    }

    @Override
    public class_2561 getDescription() {
        return GuiText.MENetworkStorage.text();
    }

    private record MountOperation(int priority, MEStorage storage) implements QueuedOperation
    {
    }

    private record UnmountOperation(MEStorage storage) implements QueuedOperation
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface QueuedOperation {
    }
}

