/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.config.CpuSelectionMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.core.sync.packets.CraftingStatusPacket;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.menu.AEBaseMenu;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.IncrementalUpdateHelper;
import appeng.menu.me.crafting.CraftingStatus;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_3917;

public class CraftingCPUMenu
extends AEBaseMenu {
    private static final String ACTION_CANCEL_CRAFTING = "cancelCrafting";
    public static final class_3917<CraftingCPUMenu> TYPE = MenuTypeBuilder.create(CraftingCPUMenu::new, CraftingBlockEntity.class).requirePermission(SecurityPermissions.CRAFT).withMenuTitle(craftingBlockEntity -> {
        CraftingCPUCluster cluster = craftingBlockEntity.getCluster();
        if (cluster != null && cluster.getName() != null) {
            return cluster.getName();
        }
        return class_2561.method_43473();
    }).build("craftingcpu");
    private final IncrementalUpdateHelper incrementalUpdateHelper = new IncrementalUpdateHelper();
    private final IGrid grid;
    private CraftingCPUCluster cpu = null;
    private final Consumer<AEKey> cpuChangeListener = this.incrementalUpdateHelper::addChange;
    @GuiSync(value=0)
    public CpuSelectionMode schedulingMode = CpuSelectionMode.ANY;
    @GuiSync(value=1)
    public boolean cantStoreItems = false;

    public CraftingCPUMenu(class_3917<?> menuType, int id, class_1661 ip, Object te) {
        super(menuType, id, ip, te);
        IActionHost host = (IActionHost)(te instanceof IActionHost ? te : null);
        this.grid = host != null && host.getActionableNode() != null ? host.getActionableNode().getGrid() : null;
        if (te instanceof CraftingBlockEntity) {
            this.setCPU(((CraftingBlockEntity)te).getCluster());
        }
        if (this.getGrid() == null && this.isServerSide()) {
            this.setValidMenu(false);
        }
        this.registerClientAction(ACTION_CANCEL_CRAFTING, this::cancelCrafting);
    }

    protected void setCPU(ICraftingCPU c) {
        if (c == this.cpu) {
            return;
        }
        if (this.cpu != null) {
            this.cpu.craftingLogic.removeListener(this.cpuChangeListener);
        }
        this.incrementalUpdateHelper.reset();
        if (c instanceof CraftingCPUCluster) {
            this.cpu = (CraftingCPUCluster)c;
            KeyCounter allItems = new KeyCounter();
            this.cpu.craftingLogic.getAllItems(allItems);
            for (Object2LongMap.Entry<AEKey> entry : allItems) {
                this.incrementalUpdateHelper.addChange((AEKey)entry.getKey());
            }
            this.cpu.craftingLogic.addListener(this.cpuChangeListener);
        } else {
            this.cpu = null;
            this.sendPacketToClient(new CraftingStatusPacket(CraftingStatus.EMPTY));
        }
    }

    public void cancelCrafting() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CANCEL_CRAFTING);
        } else if (this.cpu != null) {
            this.cpu.cancel();
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.cpu != null) {
            this.cpu.craftingLogic.removeListener(this.cpuChangeListener);
        }
    }

    @Override
    public void method_7623() {
        if (this.isServerSide() && this.cpu != null) {
            this.schedulingMode = this.cpu.getSelectionMode();
            this.cantStoreItems = this.cpu.craftingLogic.isCantStoreItems();
            if (this.incrementalUpdateHelper.hasChanges()) {
                CraftingStatus status = CraftingStatus.create(this.incrementalUpdateHelper, this.cpu.craftingLogic);
                this.incrementalUpdateHelper.commitChanges();
                this.sendPacketToClient(new CraftingStatusPacket(status));
            }
        }
        super.method_7623();
    }

    public CpuSelectionMode getSchedulingMode() {
        return this.schedulingMode;
    }

    public boolean isCantStoreItems() {
        return this.cantStoreItems;
    }

    public boolean allowConfiguration() {
        return true;
    }

    IGrid getGrid() {
        return this.grid;
    }
}

