/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.interaction;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.GenericStack;
import appeng.util.GenericContainerHelper;
import appeng.util.fluid.FluidSoundHelper;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class FluidContainerItemStrategy
implements ContainerItemStrategy<AEFluidKey, Storage<FluidVariant>> {
    @Override
    @Nullable
    public GenericStack getContainedStack(class_1799 stack) {
        return GenericContainerHelper.getContainedFluidStack(stack);
    }

    @Override
    @Nullable
    public Storage<FluidVariant> findCarriedContext(class_1657 player, class_1703 menu) {
        return (Storage)ContainerItemContext.ofPlayerCursor((class_1657)player, (class_1703)menu).find(FluidStorage.ITEM);
    }

    @Override
    @Nullable
    public Storage<FluidVariant> findPlayerSlotContext(class_1657 player, int slot) {
        PlayerInventoryStorage playerInv = PlayerInventoryStorage.of((class_1661)player.method_31548());
        return (Storage)ContainerItemContext.ofPlayerSlot((class_1657)player, (SingleSlotStorage)((SingleSlotStorage)playerInv.getSlots().get(slot))).find(FluidStorage.ITEM);
    }

    @Override
    public long extract(Storage<FluidVariant> context, AEFluidKey what, long amount, Actionable mode) {
        try (Transaction tx = Transaction.openOuter();){
            long extracted = context.extract((Object)what.toVariant(), amount, (TransactionContext)tx);
            if (mode == Actionable.MODULATE) {
                tx.commit();
            }
            long l = extracted;
            return l;
        }
    }

    @Override
    public long insert(Storage<FluidVariant> context, AEFluidKey what, long amount, Actionable mode) {
        try (Transaction tx = Transaction.openOuter();){
            long inserted = context.insert((Object)what.toVariant(), amount, (TransactionContext)tx);
            if (mode == Actionable.MODULATE) {
                tx.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public void playFillSound(class_1657 player, AEFluidKey what) {
        FluidSoundHelper.playFillSound(player, what);
    }

    @Override
    public void playEmptySound(class_1657 player, AEFluidKey what) {
        FluidSoundHelper.playEmptySound(player, what);
    }

    @Override
    @Nullable
    public GenericStack getExtractableContent(Storage<FluidVariant> context) {
        ResourceAmount resourceAmount = StorageUtil.findExtractableContent(context, null);
        if (resourceAmount == null) {
            return null;
        }
        return new GenericStack(AEFluidKey.of((FluidVariant)resourceAmount.resource()), resourceAmount.amount());
    }
}

