/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.parts.IStorageMonitorPart;
import appeng.api.networking.IStackWatcher;
import appeng.api.networking.storage.IStorageService;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.render.BlockEntityRenderHelper;
import appeng.core.localization.PlayerMessages;
import appeng.menu.me.interaction.StackInteractions;
import appeng.parts.reporting.AbstractDisplayPart;
import appeng.util.Platform;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public abstract class AbstractMonitorPart
extends AbstractDisplayPart
implements IStorageMonitorPart,
IStorageWatcherNode {
    @Nullable
    private AEKey configuredItem;
    private long amount;
    private String lastHumanReadableText;
    private boolean isLocked;
    private IStackWatcher myWatcher;

    public AbstractMonitorPart(IPartItem<?> partItem, boolean requireChannel) {
        super(partItem, requireChannel);
        this.getMainNode().addService(IStorageWatcherNode.class, this);
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.isLocked = data.method_10577("isLocked");
        this.configuredItem = AEKey.fromTagGeneric(data.method_10562("configuredItem"));
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10556("isLocked", this.isLocked);
        if (this.configuredItem != null) {
            data.method_10566("configuredItem", (class_2520)this.configuredItem.toTagGeneric());
        }
    }

    @Override
    public void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredItem != null);
        if (this.configuredItem != null) {
            AEKey.writeKey(data, this.configuredItem);
            data.method_10791(this.amount);
        }
    }

    @Override
    public boolean readFromStream(class_2540 data) {
        boolean needRedraw = super.readFromStream(data);
        boolean isLocked = data.readBoolean();
        needRedraw |= this.isLocked != isLocked;
        this.isLocked = isLocked;
        if (data.readBoolean()) {
            this.configuredItem = AEKey.readKey(data);
            this.amount = data.method_10792();
        } else {
            this.configuredItem = null;
            this.amount = 0L;
        }
        return needRedraw;
    }

    @Override
    public void writeVisualStateToNBT(class_2487 data) {
        super.writeVisualStateToNBT(data);
        data.method_10544("amount", this.amount);
    }

    @Override
    public void readVisualStateFromNBT(class_2487 data) {
        super.readVisualStateFromNBT(data);
        this.amount = data.method_10537("amount");
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (this.isClientSide()) {
            return true;
        }
        if (!this.getMainNode().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getHost().getLocation(), player)) {
            return false;
        }
        if (!this.isLocked) {
            class_1799 eq = player.method_5998(hand);
            if (AEItemKey.matches(this.configuredItem, eq)) {
                GenericStack containedStack = StackInteractions.getContainedStack(eq);
                if (containedStack != null) {
                    this.configuredItem = containedStack.what();
                }
            } else {
                this.configuredItem = AEItemKey.of(eq);
            }
        } else {
            return super.onPartActivate(player, hand, pos);
        }
        this.configureWatchers();
        this.getHost().markForSave();
        this.getHost().markForUpdate();
        return true;
    }

    @Override
    public boolean onPartShiftActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (this.isClientSide()) {
            return true;
        }
        if (!this.getMainNode().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getHost().getLocation(), player)) {
            return false;
        }
        if (player.method_5998(hand).method_7960()) {
            this.isLocked = !this.isLocked;
            player.method_43496((class_2561)(this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).text());
            this.getHost().markForSave();
            this.getHost().markForUpdate();
        }
        return true;
    }

    private void configureWatchers() {
        if (this.myWatcher != null) {
            this.myWatcher.reset();
        }
        if (this.configuredItem != null) {
            if (this.myWatcher != null) {
                this.myWatcher.add(this.configuredItem);
            }
            this.getMainNode().ifPresent(grid -> this.updateReportingValue(grid.getStorageService()));
        }
    }

    private void updateReportingValue(IStorageService storageService) {
        this.lastHumanReadableText = null;
        this.amount = this.configuredItem != null ? storageService.getCachedInventory().get(this.configuredItem) : 0L;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderDynamic(float partialTicks, class_4587 poseStack, class_4597 buffers, int combinedLightIn, int combinedOverlayIn) {
        if (!this.isActive()) {
            return;
        }
        if (this.configuredItem == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        BlockEntityRenderHelper.rotateToFace(poseStack, this.getSide(), this.getSpin());
        poseStack.method_22904(0.0, 0.05, 0.5);
        BlockEntityRenderHelper.renderItem2dWithAmount(poseStack, buffers, this.getDisplayed(), this.amount, 0.4f, -0.23f, this.getColor().contrastTextColor);
        poseStack.method_22909();
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    @Override
    @Nullable
    public AEKey getDisplayed() {
        return this.configuredItem;
    }

    public void setConfiguredItem(@Nullable AEKey configuredItem) {
        this.configuredItem = configuredItem;
        this.getHost().markForUpdate();
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
        this.getHost().markForUpdate();
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onStackChange(AEKey what, long amount) {
        if (what.equals(this.configuredItem)) {
            this.amount = amount;
            String humanReadableText = what.formatAmount(amount, AmountFormat.SLOT);
            if (!humanReadableText.equals(this.lastHumanReadableText)) {
                this.lastHumanReadableText = humanReadableText;
                this.getHost().markForUpdate();
            }
        }
    }

    @Override
    public boolean showNetworkInfo(class_1838 context) {
        return false;
    }

    protected IPartModel selectModel(IPartModel off, IPartModel on, IPartModel hasChannel, IPartModel lockedOff, IPartModel lockedOn, IPartModel lockedHasChannel) {
        if (this.isActive()) {
            if (this.isLocked()) {
                return lockedHasChannel;
            }
            return hasChannel;
        }
        if (this.isPowered()) {
            if (this.isLocked()) {
                return lockedOn;
            }
            return on;
        }
        if (this.isLocked()) {
            return lockedOff;
        }
        return off;
    }
}

