/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.api.features.IPlayerRegistry;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.items.storage.SpatialStorageCellItem;
import appeng.server.ISubCommand;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStoragePlotManager;
import appeng.spatial.TransitionInfo;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class SpatialStorageCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").executes(ctx -> {
            SpatialStorageCommand.showPlotInfo((class_2168)ctx.getSource(), SpatialStorageCommand.getCurrentPlot((class_2168)ctx.getSource()));
            return 1;
        })).then(class_2170.method_9244((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            SpatialStorageCommand.showPlotInfo((class_2168)ctx.getSource(), SpatialStorageCommand.getPlot(plotId));
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"tp").then(class_2170.method_9244((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            SpatialStorageCommand.teleportToPlot((class_2168)ctx.getSource(), plotId);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tpback").executes(ctx -> {
            this.teleportBack((class_2168)ctx.getSource());
            return 1;
        })).then(class_2170.method_9244((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            this.teleportBack((class_2168)ctx.getSource(), SpatialStorageCommand.getPlot(plotId));
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"givecell").then(class_2170.method_9244((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            this.giveCell((class_2168)ctx.getSource(), plotId);
            return 1;
        })));
    }

    private void teleportBack(class_2168 source) {
        if (source.method_9225().method_27983() != SpatialStorageDimensionIds.WORLD_ID) {
            throw new class_2164((class_2561)PlayerMessages.NotInSpatialStorageLevel.text());
        }
        class_2338 playerPos = new class_2338(source.method_9222());
        int x = playerPos.method_10263();
        int z = playerPos.method_10260();
        for (SpatialStoragePlot plot : SpatialStoragePlotManager.INSTANCE.getPlots()) {
            class_2338 origin = plot.getOrigin();
            class_2338 size = plot.getSize();
            if (x < origin.method_10263() || x > origin.method_10263() + size.method_10263() || z < origin.method_10260() || z > origin.method_10260() + size.method_10260()) continue;
            this.teleportBack(source, plot);
            return;
        }
        throw new class_2164((class_2561)PlayerMessages.PlotNotFoundForCurrentPosition.text());
    }

    private void teleportBack(class_2168 source, SpatialStoragePlot plot) {
        TransitionInfo lastTransition = plot.getLastTransition();
        if (lastTransition == null) {
            throw new class_2164((class_2561)PlayerMessages.NoLastTransition.text());
        }
        String command = SpatialStorageCommand.getTeleportCommand(lastTransition.getWorldId(), lastTransition.getMin().method_10069(0, 1, 0));
        SpatialStorageCommand.runCommandFor(source, command);
    }

    private static void showPlotInfo(class_2168 source, SpatialStoragePlot plot) {
        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.PlotID.text(), String.valueOf(plot.getId()));
        int playerId = plot.getOwner();
        if (playerId != -1) {
            MinecraftServer server = source.method_9211();
            UUID profileId = IPlayerRegistry.getMapping(server).getProfileId(playerId);
            if (profileId == null) {
                SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Owner.text(), (class_2561)PlayerMessages.UnknownAE2Player.text(playerId));
            } else {
                class_3222 player = server.method_3760().method_14602(profileId);
                if (player != null) {
                    SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Owner.text(), (class_2561)PlayerMessages.PlayerConnected.text(player.method_7334().getName()));
                } else {
                    Optional cachedProfile = server.method_3793().method_14512(profileId);
                    if (cachedProfile.isPresent()) {
                        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Owner.text(), (class_2561)PlayerMessages.PlayerDisconnected.text(((GameProfile)cachedProfile.get()).getName()));
                    } else {
                        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Owner.text(), (class_2561)PlayerMessages.MinecraftProfile.text(profileId));
                    }
                }
            }
        } else {
            SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Owner.text(), (class_2561)PlayerMessages.Unknown.text());
        }
        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Size.text(), SpatialStorageCommand.formatBlockPos(plot.getSize(), "x"));
        String teleportToPlotCommand = SpatialStorageCommand.getTeleportCommand(SpatialStorageDimensionIds.WORLD_ID.method_29177(), plot.getOrigin());
        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Origin.text(), (class_2561)class_2561.method_43470((String)SpatialStorageCommand.formatBlockPos(plot.getOrigin(), ",")).method_27694(SpatialStorageCommand.makeCommandLink(teleportToPlotCommand, PlayerMessages.ClickToTeleport.text())));
        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.RegionFile.text(), plot.getRegionFilename());
        TransitionInfo lastTransition = plot.getLastTransition();
        if (lastTransition != null) {
            source.method_9226((class_2561)PlayerMessages.LastTransition.text().method_27695(new class_124[]{class_124.field_1073, class_124.field_1067}), true);
            String sourceWorldId = lastTransition.getWorldId().toString();
            class_5250 sourceLink = PlayerMessages.SourceLink.text(sourceWorldId, SpatialStorageCommand.formatBlockPos(lastTransition.getMin(), ","), SpatialStorageCommand.formatBlockPos(lastTransition.getMax(), ","));
            String tpCommand = SpatialStorageCommand.getTeleportCommand(lastTransition.getWorldId(), lastTransition.getMin().method_10069(0, 1, 0));
            sourceLink.method_27694(SpatialStorageCommand.makeCommandLink(tpCommand, PlayerMessages.ClickToTeleport.text()));
            SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Source.text(), (class_2561)sourceLink);
            SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.When.text(), lastTransition.getTimestamp().toString());
        } else {
            source.method_9226((class_2561)PlayerMessages.LastTransitionUnknown.text(), true);
        }
    }

    private static void teleportToPlot(class_2168 source, int plotId) {
        SpatialStoragePlot plot = SpatialStorageCommand.getPlot(plotId);
        String teleportCommand = SpatialStorageCommand.getTeleportCommand(SpatialStorageDimensionIds.WORLD_ID.method_29177(), plot.getOrigin());
        SpatialStorageCommand.runCommandFor(source, teleportCommand);
    }

    private void giveCell(class_2168 source, int plotId) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        SpatialStoragePlot plot = SpatialStorageCommand.getPlot(plotId);
        int longestSide = SpatialStorageCommand.getLongestSide(plot.getSize());
        class_1799 cell = longestSide <= 2 ? AEItems.SPATIAL_CELL2.stack() : (longestSide <= 16 ? AEItems.SPATIAL_CELL16.stack() : AEItems.SPATIAL_CELL128.stack());
        class_1792 class_17922 = cell.method_7909();
        if (!(class_17922 instanceof SpatialStorageCellItem)) {
            throw new class_2164((class_2561)PlayerMessages.NotStorageCell.text());
        }
        SpatialStorageCellItem spatialCellItem = (SpatialStorageCellItem)class_17922;
        spatialCellItem.setStoredDimension(cell, plotId, plot.getSize());
        player.method_7270(cell);
    }

    private static int getLongestSide(class_2338 size) {
        return Math.max(size.method_10263(), Math.max(size.method_10264(), size.method_10260()));
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<class_2168> ctx, class_2168 sender) {
        try {
            SpatialStoragePlotManager.INSTANCE.getLevel();
        }
        catch (IllegalStateException e) {
            sender.method_9226((class_2561)PlayerMessages.NoSpatialIOLevel.text(e.getMessage()), true);
            return;
        }
        ArrayList<SpatialStoragePlot> plots = new ArrayList<SpatialStoragePlot>(SpatialStoragePlotManager.INSTANCE.getPlots());
        if (plots.isEmpty()) {
            sender.method_9226((class_2561)PlayerMessages.NoSpatialIOPlots.text(), true);
            return;
        }
        plots.sort(Comparator.comparing(plot -> {
            TransitionInfo lastTransition = plot.getLastTransition();
            if (lastTransition != null) {
                return lastTransition.getTimestamp();
            }
            return Instant.MIN;
        }).reversed());
        for (int i = 0; i < Math.min(5, plots.size()); ++i) {
            SpatialStoragePlot plot2 = (SpatialStoragePlot)plots.get(i);
            String size = SpatialStorageCommand.formatBlockPos(plot2.getSize(), "x");
            class_2338 originPos = plot2.getOrigin();
            String origin = SpatialStorageCommand.formatBlockPos(originPos, ",");
            class_5250 infoLink = PlayerMessages.Plot.text().method_27693(" #" + plot2.getId()).method_27694(SpatialStorageCommand.makeCommandLink("/ae2 spatial info " + plot2.getId(), PlayerMessages.ClickToShowDetails.text()));
            class_5250 tpLink = PlayerMessages.Origin.text().method_27693(": " + origin).method_27694(SpatialStorageCommand.makeCommandLink("/ae2 spatial tp " + plot2.getId(), PlayerMessages.ClickToTeleport.text()));
            class_5250 message = class_2561.method_43470((String)"").method_10852((class_2561)infoLink).method_27693(" ").method_10852((class_2561)PlayerMessages.Size.text()).method_27693(": " + size + " ").method_10852((class_2561)tpLink);
            sender.method_9226((class_2561)message, true);
        }
    }

    private static String formatBlockPos(class_2338 size, String separator) {
        return size.method_10263() + separator + size.method_10264() + separator + size.method_10260();
    }

    private static UnaryOperator<class_2583> makeCommandLink(String command, class_5250 tooltip) {
        return style -> style.method_27706(class_124.field_1073).method_10958(new class_2558(class_2558.class_2559.field_11750, command)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)tooltip));
    }

    private static void runCommandFor(class_2168 source, String command) {
        class_2170 commandManager = source.method_9211().method_3734();
        commandManager.method_44252(source, command);
    }

    private static String getTeleportCommand(class_2960 worldId, class_2338 pos) {
        return "/execute in " + worldId + " run tp @s " + pos.method_10263() + " " + (pos.method_10264() + 1) + " " + pos.method_10260();
    }

    private static SpatialStoragePlot getPlot(int plotId) {
        SpatialStoragePlot plot = SpatialStoragePlotManager.INSTANCE.getPlot(plotId);
        if (plot == null) {
            throw new class_2164((class_2561)PlayerMessages.PlotNotFound.text(plotId));
        }
        return plot;
    }

    private static void sendKeyValuePair(class_2168 source, class_5250 label, class_2561 value) {
        source.method_9226((class_2561)label.method_27693(": ").method_27692(class_124.field_1067).method_10852(value), true);
    }

    private static void sendKeyValuePair(class_2168 source, class_5250 label, String value) {
        SpatialStorageCommand.sendKeyValuePair(source, label, (class_2561)class_2561.method_43470((String)value));
    }

    private static SpatialStoragePlot getCurrentPlot(class_2168 source) {
        if (source.method_9225().method_27983() != SpatialStorageDimensionIds.WORLD_ID) {
            throw new class_2164((class_2561)PlayerMessages.NotInSpatialStorageLevel.text());
        }
        class_2338 playerPos = new class_2338(source.method_9222());
        int x = playerPos.method_10263();
        int z = playerPos.method_10260();
        for (SpatialStoragePlot plot : SpatialStoragePlotManager.INSTANCE.getPlots()) {
            class_2338 origin = plot.getOrigin();
            class_2338 size = plot.getSize();
            if (x < origin.method_10263() || x > origin.method_10263() + size.method_10263() || z < origin.method_10260() || z > origin.method_10260() + size.method_10260()) continue;
            return plot;
        }
        throw new class_2164((class_2561)PlayerMessages.PlotNotFoundForCurrentPosition.text());
    }
}

