/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.util.WorldCoord;
import appeng.block.spatial.MatrixFrameBlock;
import appeng.core.definitions.AEBlocks;
import appeng.core.stats.AdvancementTriggers;
import appeng.spatial.CachedPlane;
import appeng.spatial.ISpatialVisitor;
import appeng.spatial.SpatialStorageDimensionIds;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5454;

public class SpatialStorageHelper {
    private static SpatialStorageHelper instance;

    public static SpatialStorageHelper getInstance() {
        if (instance == null) {
            instance = new SpatialStorageHelper();
        }
        return instance;
    }

    private class_1297 teleportEntity(class_1297 entity, TelDestination link) {
        class_5454 portalInfo;
        class_3218 newLevel;
        class_3218 oldLevel;
        try {
            oldLevel = (class_3218)entity.field_6002;
            newLevel = link.dim;
        }
        catch (Throwable e) {
            return entity;
        }
        if (oldLevel == null) {
            return entity;
        }
        if (newLevel == null) {
            return entity;
        }
        if (newLevel == oldLevel) {
            newLevel.method_14178().method_12121(class_3532.method_15357((double)link.x) >> 4, class_3532.method_15357((double)link.z) >> 4, class_2806.field_12803, true);
            entity.method_5859(link.x, link.y, link.z);
            return entity;
        }
        if (entity.method_5765()) {
            return this.teleportEntity(entity.method_5854(), link);
        }
        List passengers = entity.method_5685();
        ArrayList<class_1297> passengersOnOtherSide = new ArrayList<class_1297>(passengers.size());
        for (class_1297 passenger : passengers) {
            passenger.method_5848();
            passengersOnOtherSide.add(this.teleportEntity(passenger, link));
        }
        newLevel.method_14178().method_12121(class_3532.method_15357((double)link.x) >> 4, class_3532.method_15357((double)link.z) >> 4, class_2806.field_12803, true);
        if (entity instanceof class_3222 && link.dim.method_27983() == SpatialStorageDimensionIds.WORLD_ID) {
            AdvancementTriggers.SPATIAL_EXPLORER.trigger((class_3222)entity);
        }
        if ((entity = FabricDimensions.teleport((class_1297)entity, (class_3218)link.dim, (class_5454)(portalInfo = new class_5454(new class_243(link.x, link.y, link.z), class_243.field_1353, entity.method_36454(), entity.method_36455())))) != null && !passengersOnOtherSide.isEmpty()) {
            for (class_1297 passanger : passengersOnOtherSide) {
                passanger.method_5873(entity, true);
            }
        }
        return entity;
    }

    private void transverseEdges(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, ISpatialVisitor visitor) {
        int x;
        int z;
        for (int y = minY; y < maxY; ++y) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(new class_2338(minX, y, z));
                visitor.visit(new class_2338(maxX, y, z));
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(new class_2338(x, minY, z));
                visitor.visit(new class_2338(x, maxY, z));
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                visitor.visit(new class_2338(x, y, minZ));
                visitor.visit(new class_2338(x, y, maxZ));
            }
        }
    }

    public void swapRegions(class_3218 srcLevel, int srcX, int srcY, int srcZ, class_3218 dstLevel, int dstX, int dstY, int dstZ, int scaleX, int scaleY, int scaleZ) {
        MatrixFrameBlock matrixFrameBlock = AEBlocks.MATRIX_FRAME.block();
        this.transverseEdges(dstX - 1, dstY - 1, dstZ - 1, dstX + scaleX + 1, dstY + scaleY + 1, dstZ + scaleZ + 1, new WrapInMatrixFrame(matrixFrameBlock.method_9564(), (class_1937)dstLevel));
        class_238 srcBox = new class_238((double)srcX, (double)srcY, (double)srcZ, (double)(srcX + scaleX + 1), (double)(srcY + scaleY + 1), (double)(srcZ + scaleZ + 1));
        class_238 dstBox = new class_238((double)dstX, (double)dstY, (double)dstZ, (double)(dstX + scaleX + 1), (double)(dstY + scaleY + 1), (double)(dstZ + scaleZ + 1));
        CachedPlane cDst = new CachedPlane(dstLevel, dstX, dstY, dstZ, dstX + scaleX, dstY + scaleY, dstZ + scaleZ);
        CachedPlane cSrc = new CachedPlane(srcLevel, srcX, srcY, srcZ, srcX + scaleX, srcY + scaleY, srcZ + scaleZ);
        cSrc.swap(cDst);
        List srcE = srcLevel.method_18467(class_1297.class, srcBox);
        List dstE = dstLevel.method_18467(class_1297.class, dstBox);
        for (class_1297 e : dstE) {
            this.teleportEntity(e, new TelDestination(srcLevel, srcBox, e.method_23317(), e.method_23318(), e.method_23321(), -dstX + srcX, -dstY + srcY, -dstZ + srcZ));
        }
        for (class_1297 e : srcE) {
            this.teleportEntity(e, new TelDestination(dstLevel, dstBox, e.method_23317(), e.method_23318(), e.method_23321(), -srcX + dstX, -srcY + dstY, -srcZ + dstZ));
        }
        for (WorldCoord wc : cDst.getUpdates()) {
            cSrc.getLevel().method_8452(wc.getPos(), class_2246.field_10124);
        }
        for (WorldCoord wc : cSrc.getUpdates()) {
            cSrc.getLevel().method_8452(wc.getPos(), class_2246.field_10124);
        }
        this.transverseEdges(srcX - 1, srcY - 1, srcZ - 1, srcX + scaleX + 1, srcY + scaleY + 1, srcZ + scaleZ + 1, new TriggerUpdates((class_1937)srcLevel));
        this.transverseEdges(dstX - 1, dstY - 1, dstZ - 1, dstX + scaleX + 1, dstY + scaleY + 1, dstZ + scaleZ + 1, new TriggerUpdates((class_1937)dstLevel));
        this.transverseEdges(srcX, srcY, srcZ, srcX + scaleX, srcY + scaleY, srcZ + scaleZ, new TriggerUpdates((class_1937)srcLevel));
        this.transverseEdges(dstX, dstY, dstZ, dstX + scaleX, dstY + scaleY, dstZ + scaleZ, new TriggerUpdates((class_1937)dstLevel));
    }

    private static class TelDestination {
        private final class_3218 dim;
        private final double x;
        private final double y;
        private final double z;

        TelDestination(class_3218 dimension, class_238 srcBox, double x, double y, double z, int blockEntityX, int blockEntityY, int blockEntityZ) {
            this.dim = dimension;
            this.x = Math.min(srcBox.field_1320 - 0.5, Math.max(srcBox.field_1323 + 0.5, x + (double)blockEntityX));
            this.y = Math.min(srcBox.field_1325 - 0.5, Math.max(srcBox.field_1322 + 0.5, y + (double)blockEntityY));
            this.z = Math.min(srcBox.field_1324 - 0.5, Math.max(srcBox.field_1321 + 0.5, z + (double)blockEntityZ));
        }
    }

    private static class WrapInMatrixFrame
    implements ISpatialVisitor {
        private final class_1937 dst;
        private final class_2680 state;

        public WrapInMatrixFrame(class_2680 state, class_1937 dst2) {
            this.dst = dst2;
            this.state = state;
        }

        @Override
        public void visit(class_2338 pos) {
            this.dst.method_8501(pos, this.state);
        }
    }

    private static class TriggerUpdates
    implements ISpatialVisitor {
        private final class_1937 dst;

        public TriggerUpdates(class_1937 dst2) {
            this.dst = dst2;
        }

        @Override
        public void visit(class_2338 pos) {
            class_2680 state = this.dst.method_8320(pos);
            class_2248 blk = state.method_26204();
            blk.method_9612(state, this.dst, pos, blk, pos, false);
        }
    }
}

