/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.block.AEBaseBlock;
import appeng.core.AEConfig;
import appeng.core.definitions.AEBlocks;
import appeng.decorative.solid.CertusQuartzClusterBlock;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.fallout.Fallout;
import appeng.worldgen.meteorite.fallout.FalloutCopy;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import appeng.worldgen.meteorite.fallout.FalloutSand;
import appeng.worldgen.meteorite.fallout.FalloutSnow;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1542;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_5542;
import net.minecraft.class_5819;

public final class MeteoritePlacer {
    private final class_2680 skyStone;
    private final List<class_2680> quartzBlocks;
    private final List<class_2680> quartzBuds;
    private final MeteoriteBlockPutter putter = new MeteoriteBlockPutter();
    private final class_1936 level;
    private final class_5819 random;
    private final Fallout type;
    private final class_2338 pos;
    private final int x;
    private final int y;
    private final int z;
    private final double meteoriteSize;
    private final double squaredMeteoriteSize;
    private final double crater;
    private final boolean placeCrater;
    private final CraterType craterType;
    private final boolean pureCrater;
    private final boolean craterLake;
    private final class_3341 boundingBox;

    public static void place(class_1936 level, PlacedMeteoriteSettings settings, class_3341 boundingBox, class_5819 random) {
        MeteoritePlacer placer = new MeteoritePlacer(level, settings, boundingBox, random);
        placer.place();
    }

    private MeteoritePlacer(class_1936 level, PlacedMeteoriteSettings settings, class_3341 boundingBox, class_5819 random) {
        this.boundingBox = boundingBox;
        this.level = level;
        this.random = random;
        this.pos = settings.getPos();
        this.x = settings.getPos().method_10263();
        this.y = settings.getPos().method_10264();
        this.z = settings.getPos().method_10260();
        this.meteoriteSize = settings.getMeteoriteRadius();
        this.placeCrater = settings.shouldPlaceCrater();
        this.craterType = settings.getCraterType();
        this.pureCrater = settings.isPureCrater();
        this.craterLake = settings.isCraterLake();
        this.squaredMeteoriteSize = this.meteoriteSize * this.meteoriteSize;
        double realCrater = this.meteoriteSize * 2.0 + 5.0;
        this.crater = realCrater * realCrater;
        this.quartzBlocks = Stream.of(AEBlocks.QUARTZ_BLOCK, AEBlocks.DAMAGED_BUDDING_QUARTZ, AEBlocks.CHIPPED_BUDDING_QUARTZ, AEBlocks.FLAWED_BUDDING_QUARTZ, AEBlocks.FLAWLESS_BUDDING_QUARTZ).map(def -> ((AEBaseBlock)((Object)((Object)def.block()))).method_9564()).toList();
        this.quartzBuds = Stream.of(AEBlocks.SMALL_QUARTZ_BUD, AEBlocks.MEDIUM_QUARTZ_BUD, AEBlocks.LARGE_QUARTZ_BUD).map(def -> ((CertusQuartzClusterBlock)((Object)((Object)def.block()))).method_9564()).toList();
        this.skyStone = AEBlocks.SKY_STONE_BLOCK.block().method_9564();
        this.type = this.getFallout(level, settings.getPos(), settings.getFallout());
    }

    public void place() {
        if (this.placeCrater) {
            this.placeCrater();
        }
        this.placeMeteorite();
        if (this.placeCrater) {
            this.decay();
        }
        if (this.craterLake) {
            this.placeCraterLake();
        }
    }

    private int minX(int x) {
        if (x < this.boundingBox.method_35415()) {
            return this.boundingBox.method_35415();
        }
        if (x > this.boundingBox.method_35418()) {
            return this.boundingBox.method_35418();
        }
        return x;
    }

    private int minZ(int x) {
        if (x < this.boundingBox.method_35417()) {
            return this.boundingBox.method_35417();
        }
        if (x > this.boundingBox.method_35420()) {
            return this.boundingBox.method_35420();
        }
        return x;
    }

    private int maxX(int x) {
        if (x < this.boundingBox.method_35415()) {
            return this.boundingBox.method_35415();
        }
        if (x > this.boundingBox.method_35418()) {
            return this.boundingBox.method_35418();
        }
        return x;
    }

    private int maxZ(int x) {
        if (x < this.boundingBox.method_35417()) {
            return this.boundingBox.method_35417();
        }
        if (x > this.boundingBox.method_35420()) {
            return this.boundingBox.method_35420();
        }
        return x;
    }

    private void placeCrater() {
        int maxY = 255;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        class_2680 filler = this.craterType.getFiller().method_9564();
        for (int j = this.y - 5; j <= 255; ++j) {
            blockPos.method_33098(j);
            for (int i = this.boundingBox.method_35415(); i <= this.boundingBox.method_35418(); ++i) {
                blockPos.method_33097(i);
                for (int k = this.boundingBox.method_35417(); k <= this.boundingBox.method_35420(); ++k) {
                    blockPos.method_33099(k);
                    double dx = i - this.x;
                    double dz = k - this.z;
                    double h = (double)this.y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    double distanceFrom = dx * dx + dz * dz;
                    if (!((double)j > h + distanceFrom * 0.02)) continue;
                    class_2680 currentBlock = this.level.method_8320((class_2338)blockPos);
                    if (this.craterType != CraterType.NORMAL && j < this.y && currentBlock.method_26207().method_15799()) {
                        if (!((double)j > h + distanceFrom * 0.02)) continue;
                        this.putter.put(this.level, (class_2338)blockPos, filler);
                        continue;
                    }
                    this.putter.put(this.level, (class_2338)blockPos, class_2246.field_10124.method_9564());
                }
            }
        }
        for (class_1542 e : this.level.method_18467(class_1542.class, new class_238((double)this.minX(this.x - 30), (double)(this.y - 5), (double)this.minZ(this.z - 30), (double)this.maxX(this.x + 30), (double)(this.y + 30), (double)this.maxZ(this.z + 30)))) {
            e.method_31472();
        }
    }

    private void placeMeteorite() {
        this.placeMeteoriteSkyStone();
        if (this.boundingBox.method_14662((class_2382)this.pos)) {
            this.placeChest();
        }
    }

    private void placeChest() {
        if (AEConfig.instance().isSpawnPressesInMeteoritesEnabled()) {
            this.putter.put(this.level, this.pos, AEBlocks.MYSTERIOUS_CUBE.block().method_9564());
        }
    }

    private void placeMeteoriteSkyStone() {
        int meteorXLength = this.minX(this.x - 8);
        int meteorXHeight = this.maxX(this.x + 8);
        int meteorZLength = this.minZ(this.z - 8);
        int meteorZHeight = this.maxZ(this.z + 8);
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int i = meteorXLength; i <= meteorXHeight; ++i) {
            pos.method_33097(i);
            for (int j = this.y - 8; j < this.y + 8; ++j) {
                pos.method_33098(j);
                for (int k = meteorZLength; k <= meteorZHeight; ++k) {
                    pos.method_33099(k);
                    int dx = i - this.x;
                    int dy = j - this.y;
                    int dz = k - this.z;
                    double d = (double)(dx * dx) * 0.7;
                    double d2 = dy * dy;
                    double d3 = j > this.y ? 1.4 : 0.8;
                    if (!(d + d2 * d3 + (double)(dz * dz) * 0.7 < this.squaredMeteoriteSize)) continue;
                    if (Math.abs(dx) <= 1 && Math.abs(dy) <= 1 && Math.abs(dz) <= 1) {
                        if (dy != -1) continue;
                        int certusIndex = this.random.method_43048(this.quartzBlocks.size());
                        this.putter.put(this.level, (class_2338)pos, this.quartzBlocks.get(certusIndex));
                        if (certusIndex == 0 || dx == 0 && dz == 0 || !((double)this.random.method_43057() <= 0.7)) continue;
                        class_2680 bud = this.quartzBuds.get(this.random.method_43048(this.quartzBuds.size()));
                        class_2680 budState = (class_2680)bud.method_11657((class_2769)class_5542.field_27087, (Comparable)class_2350.field_11036);
                        this.putter.put(this.level, pos.method_10069(0, 1, 0), budState);
                        continue;
                    }
                    this.putter.put(this.level, (class_2338)pos, this.skyStone);
                }
            }
        }
    }

    private void decay() {
        double randomShit = 0.0;
        int meteorXLength = this.minX(this.x - 30);
        int meteorXHeight = this.maxX(this.x + 30);
        int meteorZLength = this.minZ(this.z - 30);
        int meteorZHeight = this.maxZ(this.z + 30);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        class_2338.class_2339 blockPosUp = new class_2338.class_2339();
        class_2338.class_2339 blockPosDown = new class_2338.class_2339();
        for (int i = meteorXLength; i <= meteorXHeight; ++i) {
            blockPos.method_33097(i);
            blockPosUp.method_33097(i);
            blockPosDown.method_33097(i);
            for (int k = meteorZLength; k <= meteorZHeight; ++k) {
                blockPos.method_33099(k);
                blockPosUp.method_33099(k);
                blockPosDown.method_33099(k);
                for (int j = this.y - 9; j < this.y + 30; ++j) {
                    double dz;
                    double dy;
                    blockPos.method_33098(j);
                    blockPosUp.method_33098(j + 1);
                    blockPosDown.method_33098(j - 1);
                    class_2680 state = this.level.method_8320((class_2338)blockPos);
                    class_2248 blk = this.level.method_8320((class_2338)blockPos).method_26204();
                    if (this.pureCrater && blk == this.craterType.getFiller()) continue;
                    if (state.method_26207().method_15800()) {
                        if (!this.level.method_22347((class_2338)blockPosUp)) {
                            class_2680 stateUp = this.level.method_8320((class_2338)blockPosUp);
                            this.level.method_8652((class_2338)blockPos, stateUp, 3);
                            continue;
                        }
                        if (!(randomShit < 100.0 * this.crater)) continue;
                        double dx = i - this.x;
                        dy = j - this.y;
                        dz = k - this.z;
                        double dist = dx * dx + dy * dy + dz * dz;
                        class_2680 xf = this.level.method_8320((class_2338)blockPosDown);
                        if (xf.method_26207().method_15800()) continue;
                        double extraRange = this.random.method_43058() * 0.6;
                        double height = this.crater * (extraRange + 0.2) - Math.abs(dist - this.crater * 1.7);
                        if (xf.method_26215() || !(height > 0.0) || !(this.random.method_43058() > 0.6)) continue;
                        randomShit += 1.0;
                        this.type.getRandomFall(this.level, (class_2338)blockPos);
                        continue;
                    }
                    if (!this.level.method_22347((class_2338)blockPosUp) || !(this.random.method_43058() > 0.4)) continue;
                    double dx = i - this.x;
                    dy = j - this.y;
                    dz = k - this.z;
                    double dr2 = dx * dx + dy * dy + dz * dz;
                    if (Math.abs(dx) <= 1.0 && Math.abs(dy) <= 1.0 && Math.abs(dz) <= 1.0 || !(dr2 < this.crater * 1.6)) continue;
                    this.type.getRandomInset(this.level, (class_2338)blockPos);
                }
            }
        }
    }

    private void placeCraterLake() {
        int maxY = this.level.method_8615() - 1;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (int j = this.y - 5; j <= maxY; ++j) {
            blockPos.method_33098(j);
            for (int i = this.boundingBox.method_35415(); i <= this.boundingBox.method_35418(); ++i) {
                blockPos.method_33097(i);
                for (int k = this.boundingBox.method_35417(); k <= this.boundingBox.method_35420(); ++k) {
                    class_2680 currentBlock;
                    blockPos.method_33099(k);
                    double dx = i - this.x;
                    double dz = k - this.z;
                    double h = (double)this.y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    double distanceFrom = dx * dx + dz * dz;
                    if (!((double)j > h + distanceFrom * 0.02) || (currentBlock = this.level.method_8320((class_2338)blockPos)).method_26204() != class_2246.field_10124) continue;
                    this.putter.put(this.level, (class_2338)blockPos, class_2246.field_10382.method_9564());
                }
            }
        }
    }

    private Fallout getFallout(class_1936 level, class_2338 pos, FalloutMode mode) {
        return switch (mode) {
            case FalloutMode.SAND -> new FalloutSand(level, pos, this.putter, this.skyStone, this.random);
            case FalloutMode.TERRACOTTA -> new FalloutCopy(level, pos, this.putter, this.skyStone, this.random);
            case FalloutMode.ICE_SNOW -> new FalloutSnow(level, pos, this.putter, this.skyStone, this.random);
            default -> new Fallout(this.putter, this.skyStone, this.random);
        };
    }
}

