/*
 * Decompiled with CFR 0.152.
 */
package com.slomaxonical.architectspalette.blocks;

import com.google.common.collect.ImmutableMap;
import com.slomaxonical.architectspalette.registry.APSounds;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class CageLanternBlock
extends class_2248
implements class_3737 {
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2318.field_10927;
    public static final class_2746 INVERTED = class_2741.field_12501;
    private static final Map<class_2350, class_265> SHAPES = new ImmutableMap.Builder().put((Object)class_2350.field_11033, (Object)class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0)).put((Object)class_2350.field_11036, (Object)class_2248.method_9541((double)5.0, (double)10.0, (double)6.0, (double)11.0, (double)16.0, (double)11.0)).put((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0)).put((Object)class_2350.field_11035, (Object)class_2248.method_9541((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0)).put((Object)class_2350.field_11039, (Object)class_2248.method_9541((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0)).put((Object)class_2350.field_11034, (Object)class_2248.method_9541((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0)).build();

    public CageLanternBlock(class_4970.class_2251 properties, int poweredLightLevel) {
        super(properties.method_9631(CageLanternBlock.getLightValueLit(poweredLightLevel)));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    private static ToIntFunction<class_2680> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? lightValue : 0;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIT, WATERLOGGED, FACING, INVERTED});
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            worldIn.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)worldIn));
        }
        if (state.method_11654((class_2769)FACING) == facing && !state.method_26184((class_4538)worldIn, currentPos)) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return class_2248.method_20044((class_4538)worldIn, (class_2338)pos.method_10093(direction), (class_2350)direction.method_10153());
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidstate = context.method_8045().method_8316(context.method_8037());
        boolean flag = fluidstate.method_15772() == class_3612.field_15910;
        boolean lit = this.getLitState(this.method_9564(), context.method_8045(), context.method_8037());
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8038().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_3619 method_9527(class_2680 state) {
        return class_3619.field_15971;
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        class_2680 newState = (class_2680)state.method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)INVERTED) == false));
        worldIn.method_8652(pos, (class_2680)newState.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(this.getLitState(newState, worldIn, pos))), 2);
        class_3414 click = (Boolean)state.method_11654((class_2769)INVERTED) != false ? APSounds.CAGE_LANTERN_TOGGLE_OFF : APSounds.CAGE_LANTERN_TOGGLE_ON;
        worldIn.method_8396(player, pos, click, class_3419.field_15245, 1.0f, 1.0f);
        return class_1269.method_29236((boolean)worldIn.field_9236);
    }

    private boolean getLitState(class_2680 state, class_1937 world, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)INVERTED) ^ world.method_8479(pos);
    }

    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        boolean shouldBeLit;
        boolean lit;
        if (!worldIn.field_9236 && (lit = ((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) != (shouldBeLit = this.getLitState(state, worldIn, pos))) {
            if (lit) {
                worldIn.method_8652(pos, (class_2680)state.method_28493((class_2769)LIT), 2);
                worldIn.method_39279(pos, (class_2248)this, 2);
            } else {
                worldIn.method_8652(pos, (class_2680)state.method_28493((class_2769)LIT), 2);
            }
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return SHAPES.get(state.method_11654((class_2769)FACING));
    }

    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 rand) {
        boolean shouldBeLit = this.getLitState(state, (class_1937)worldIn, pos);
        if (shouldBeLit != (Boolean)state.method_11654((class_2769)LIT)) {
            worldIn.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(shouldBeLit)), 2);
        }
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }
}

