/*
 * Decompiled with CFR 0.152.
 */
package com.slomaxonical.architectspalette.models;

import com.slomaxonical.architectspalette.event.ModelBakeEvent;
import com.slomaxonical.architectspalette.models.HazardModel;
import com.slomaxonical.architectspalette.models.SheetMetalModel;
import com.slomaxonical.architectspalette.models.TileModel;
import com.slomaxonical.architectspalette.models.util.SpriteShift;
import com.slomaxonical.architectspalette.registry.APBlocks;
import com.slomaxonical.architectspalette.registry.util.BlockNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_773;

public class ModelSwapper {
    private static final HashMap<class_2248, Function<class_1087, class_1087>> customBlockModels = new HashMap();

    public static void init() {
        ModelBakeEvent.ON_MODELS_BAKED.register((bakedModelManager, existingModels, modelLoader) -> {
            ModelSwapper.swapBlockModel(APBlocks.UNOBTANIUM_BLOCK, TileModel::new);
            ModelSwapper.swapBlockModel(APBlocks.HAZARD_BLOCK.get(), HazardModel::new);
            ModelSwapper.swapBlockModel(APBlocks.SHEET_METAL.get(), model -> new SheetMetalModel((class_1087)model, SpriteShift.getShift("block/sheet_metal_block", "block/sheet_metal_block_ct")));
            ModelSwapper.swapBlockModel(APBlocks.SHEET_METAL.get(BlockNode.BlockType.WALL), model -> new SheetMetalModel((class_1087)model, SpriteShift.getShift("block/sheet_metal_block", "block/sheet_metal_block_ct")));
            customBlockModels.forEach((block, swapFunction) -> ModelSwapper.getAllBlockStateModelLocations(block).forEach(modelId -> existingModels.put(modelId, (class_1087)swapFunction.apply((class_1087)existingModels.get(modelId)))));
        });
    }

    public static void swapBlockModel(class_2248 block, Function<class_1087, class_1087> oldToNewFunction) {
        customBlockModels.put(block, oldToNewFunction);
    }

    public static List<class_1091> getAllBlockStateModelLocations(class_2248 block) {
        ArrayList<class_1091> models = new ArrayList<class_1091>();
        class_2960 blockRl = class_2378.field_11146.method_10221((Object)block);
        block.method_9595().method_11662().forEach(state -> models.add(class_773.method_3336((class_2960)blockRl, (class_2680)state)));
        return models;
    }

    private static class Entry {
        private final class_2960 identifier;
        private final Supplier<? extends class_2248> block;

        public Entry(class_2960 identifier, Supplier<? extends class_2248> block) {
            this.identifier = identifier;
            this.block = block;
        }

        public class_2248 getBlock() {
            return this.block.get();
        }

        public class_2960 getIdentifier() {
            return this.identifier;
        }
    }
}

