/*
 * Decompiled with CFR 0.152.
 */
package com.slomaxonical.architectspalette.registry.util;

import com.slomaxonical.architectspalette.blocks.NubBlock;
import com.slomaxonical.architectspalette.blocks.VerticalSlabBlock;
import com.slomaxonical.architectspalette.registry.util.IBlockSetBase;
import com.slomaxonical.architectspalette.registry.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_6862;

public class BlockNode
implements Supplier<class_2248> {
    public final BlockNode parent;
    public ArrayList<BlockNode> children;
    public final class_2248 base;
    public final Style style;
    public final BlockType type;
    public final Tool tool;
    public final int flags;
    private static final List<BlockNode> instances = new LinkedList<BlockNode>();

    public static void forAllBaseNodes(Consumer<BlockNode> consumer) {
        instances.forEach(consumer);
    }

    protected BlockNode(BlockNode parent, class_2248 base, BlockType type, Tool tool, Style style, int flags, String blockName) {
        this.parent = parent;
        this.type = type == null ? BlockType.BASE : type;
        this.tool = tool;
        this.style = style == null ? Style.CUBE : style;
        this.base = base == null ? this.makeBlock(blockName) : base;
        this.flags = flags;
    }

    private void setChildren(ArrayList<BlockNode> children) {
        this.children = children;
    }

    @Override
    public class_2248 get() {
        return this.base;
    }

    public class_2248 get(BlockType ... types) {
        for (BlockNode node : this.children) {
            if (node.type != types[0]) continue;
            if (types.length == 1) {
                return node.get();
            }
            return node.get(Arrays.copyOfRange(types, 1, types.length));
        }
        return null;
    }

    public class_2960 getId() {
        return class_2378.field_11146.method_10221((Object)this.base);
    }

    public String getName() {
        return this.getId().method_12832();
    }

    public void forEach(Consumer<BlockNode> consumer) {
        consumer.accept(this);
        for (BlockNode node : this.children) {
            node.forEach(consumer);
        }
    }

    public ArrayList<BlockNode> getParents() {
        ArrayList<BlockNode> list = new ArrayList<BlockNode>();
        BlockNode last = this;
        while (last.parent != null) {
            list.add(last.parent);
            last = last.parent;
        }
        return list;
    }

    public class_2248 getSibling(BlockType type) {
        if (this.parent != null) {
            return this.parent.get(type);
        }
        return null;
    }

    private FabricBlockSettings getSettings() {
        return FabricBlockSettings.copyOf((class_4970)this.parent.base);
    }

    private class_2248 makeBlock(String blockName) {
        class_2248 block;
        String name = blockName == null ? BlockNode.modifyBlockNameForType(this.type, this.parent.getName()) : blockName;
        class_2248 baseBlock = this.parent.base;
        if (baseBlock instanceof IBlockSetBase) {
            IBlockSetBase base = (IBlockSetBase)baseBlock;
            block = base.getBlockForType(this.type, this.getSettings(), baseBlock);
        } else {
            block = BlockNode.getBlockForType(this.type, this.getSettings(), baseBlock);
        }
        return RegistryUtil.createBlock(name, block, BlockNode.getTabForType(this.type));
    }

    public boolean getFlag(ExcludeFlag flag) {
        return (this.flags & flag.value) != 0;
    }

    public Style getStyle() {
        return this.style;
    }

    public BlockType getType() {
        return this.type;
    }

    public Tool getTool() {
        return this.tool;
    }

    public BlockNode getParent() {
        return this.parent;
    }

    public ArrayList<BlockNode> getChildren() {
        return this.children;
    }

    public static class_2248 getBlockForType(BlockType part, FabricBlockSettings settings, class_2248 base) {
        return switch (part) {
            case BlockType.WALL -> new class_2544((class_4970.class_2251)settings);
            case BlockType.SLAB -> new class_2482((class_4970.class_2251)settings);
            case BlockType.VERTICAL_SLAB -> new VerticalSlabBlock((class_4970.class_2251)settings);
            case BlockType.STAIRS -> new class_2510(base.method_9564(), (class_4970.class_2251)settings);
            case BlockType.FENCE -> new class_2354((class_4970.class_2251)settings);
            case BlockType.PILLAR -> new class_2465((class_4970.class_2251)settings);
            case BlockType.NUB -> new NubBlock((class_4970.class_2251)settings);
            case BlockType.BASE -> throw new IllegalStateException("Should not call makeBlock on BASE");
            default -> new class_2248((class_4970.class_2251)settings);
        };
    }

    private static String modifyBlockNameForType(BlockType type, String baseName) {
        String material = BlockNode.getMaterialFromBlock(baseName);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BlockType.BASE -> baseName;
            case BlockType.BRICKS -> material + "_bricks";
            case BlockType.CRACKED -> "cracked_" + baseName;
            case BlockType.MOSSY -> "mossy_" + baseName;
            case BlockType.TILES -> material + "_tiles";
            case BlockType.CHISELED -> "chiseled_" + baseName;
            case BlockType.PILLAR -> BlockNode.getMaterialAggressive(baseName) + "_pillar";
            case BlockType.NUB -> material + "_nub";
            case BlockType.SLAB -> material + "_slab";
            case BlockType.VERTICAL_SLAB -> material + "_vertical_slab";
            case BlockType.STAIRS -> material + "_stairs";
            case BlockType.WALL -> material + "_wall";
            case BlockType.FENCE -> material + "_fence";
            case BlockType.LAMP -> material + "_lamp";
            case BlockType.PLATING -> material + "_plating";
            case BlockType.DARK -> "dark_" + baseName;
            case BlockType.SPECIAL -> throw new IllegalStateException("SPECIAL block did not have name specified");
        };
    }

    private static class_1761 getTabForType(BlockType type) {
        return switch (type) {
            case BlockType.WALL, BlockType.FENCE, BlockType.NUB -> class_1761.field_7928;
            default -> class_1761.field_7931;
        };
    }

    private static String getMaterialFromBlock(String block) {
        return block.replace("bricks", "brick").replace("_planks", "").replace("_block", "").replace("tiles", "tile").replace("boards", "board");
    }

    private static String getMaterialAggressive(String block) {
        return BlockNode.getMaterialFromBlock(block).replace("_brick", "").replace("_tile", "").replace("chiseled_", "");
    }

    public static enum BlockType {
        BASE,
        BRICKS,
        CRACKED,
        MOSSY,
        TILES,
        CHISELED,
        PILLAR,
        NUB,
        SLAB,
        VERTICAL_SLAB,
        STAIRS,
        WALL,
        FENCE,
        LAMP,
        PLATING,
        DARK,
        SPECIAL;

    }

    public static enum Tool {
        PICK((class_6862<class_2248>)class_3481.field_33715, null),
        STONE_PICK((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33719),
        IRON_PICK((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33718),
        DIAMOND_PICK((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33717),
        AXE((class_6862<class_2248>)class_3481.field_33713, null),
        HOE((class_6862<class_2248>)class_3481.field_33714, null),
        SHOVEL((class_6862<class_2248>)class_3481.field_33716, null);

        final class_6862<class_2248> toolTag;
        final class_6862<class_2248> miningTag;

        private Tool(class_6862<class_2248> toolTag, class_6862<class_2248> miningTag) {
            this.toolTag = toolTag;
            this.miningTag = miningTag;
        }

        public class_6862<class_2248> getToolTag() {
            return this.toolTag;
        }

        public class_6862<class_2248> getMiningTag() {
            return this.miningTag;
        }
    }

    public static enum Style {
        CUBE,
        TOP_SIDES,
        TOP_SIDE_BOTTOM;

    }

    public static enum ExcludeFlag {
        MODELS(1),
        LOOT(2),
        RECIPES(4),
        TAGS(8),
        LANG(16);

        final int value;

        private ExcludeFlag(int value) {
            this.value = value;
        }
    }

    public static enum DataFlags {
        ABYSSALINE;

    }

    public static class Builder {
        protected Builder parent;
        private final ArrayList<Builder> children = new ArrayList();
        private class_2248 base;
        private Style style;
        private BlockType type;
        private Tool tool;
        private ArrayList<DataFlags> flags = new ArrayList();
        private int excludedFrom = 0;
        private String name;

        protected Builder(Builder parent, BlockType type) {
            this.parent = parent;
            this.type = type;
        }

        public Builder(BlockType type) {
            this(null, type);
        }

        public Builder() {
            this(null, BlockType.BASE);
        }

        private void inherit() {
            if (this.parent != null) {
                this.style = this.style == null ? this.parent.style : this.style;
                this.tool = this.tool == null ? this.parent.tool : this.tool;
            }
        }

        public BlockNode build() {
            if (this.parent == null) {
                BlockNode built = this.build(null);
                instances.add(built);
                return built;
            }
            throw new IllegalStateException("#build() was called on a child builder. Don't do that.");
        }

        private BlockNode build(BlockNode parent) {
            this.inherit();
            BlockNode node = new BlockNode(parent, this.base, this.type, this.tool, this.style, this.excludedFrom, this.name);
            ArrayList<BlockNode> nodeChildren = new ArrayList<BlockNode>();
            for (Builder child : this.children) {
                nodeChildren.add(child.build(node));
            }
            node.setChildren(nodeChildren);
            return node;
        }

        public Builder addChild(BlockType type) {
            Builder child = new Builder(this, type);
            this.children.add(child);
            return child;
        }

        public Builder addPart(BlockType type, Consumer<Builder> builderCode) {
            Builder child = this.addChild(type);
            builderCode.accept(child);
            return this;
        }

        public Builder addPart(BlockType type) {
            this.addChild(type);
            return this;
        }

        public Builder variants(BlockType ... types) {
            for (BlockType type : types) {
                this.addChild(type);
            }
            return this;
        }

        public Builder commonVariants() {
            this.slabs();
            return this.variants(BlockType.STAIRS, BlockType.WALL);
        }

        public Builder base(class_2248 base) {
            this.base = base;
            if (this.name == null) {
                this.name = class_2378.field_11146.method_10221((Object)base).method_12832();
            }
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder tool(Tool tool) {
            this.tool = tool;
            return this;
        }

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public Builder flag(DataFlags flag) {
            this.flags.add(flag);
            return this;
        }

        public Builder exclude(ExcludeFlag ... flags) {
            for (ExcludeFlag f : flags) {
                this.excludedFrom |= f.value;
            }
            return this;
        }

        public Builder slabs() {
            this.addChild(BlockType.SLAB);
            this.addChild(BlockType.VERTICAL_SLAB);
            return this;
        }

        public Builder stairs() {
            this.addChild(BlockType.STAIRS);
            return this;
        }

        public Builder walls() {
            this.addChild(BlockType.WALL);
            return this;
        }

        public Builder bricks(Consumer<Builder> brickCode) {
            Builder brick = this.addChild(BlockType.BRICKS);
            brick.style = Style.CUBE;
            brickCode.accept(brick);
            return this;
        }

        public Builder tiles(Consumer<Builder> tileCode) {
            Builder tile = this.addChild(BlockType.TILES);
            tile.style = Style.CUBE;
            tileCode.accept(tile);
            return this;
        }

        private Builder getBaseParent() {
            Builder p = this.parent;
            if (this.parent == null) {
                return this;
            }
            return p.getBaseParent();
        }
    }
}

