/*
 * Decompiled with CFR 0.152.
 */
package com.slomaxonical.architectspalette.registry.util;

import com.slomaxonical.architectspalette.blocks.NubBlock;
import com.slomaxonical.architectspalette.blocks.VerticalSlabBlock;
import com.slomaxonical.architectspalette.registry.util.IBlockSetBase;
import com.slomaxonical.architectspalette.registry.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_6862;

public class StoneBlockSet
implements Supplier<class_2248> {
    private final String material_name;
    public final List<class_2248> parts;
    private static final List<StoneBlockSet> instances = new LinkedList<StoneBlockSet>();
    public class_6862<class_2248> miningTag = class_3481.field_33715;
    public class_6862<class_2248> miningLevel = null;
    public boolean hasStoneCuttingRecipes = true;

    public static void forAllSets(Consumer<StoneBlockSet> consumer) {
        instances.forEach(consumer);
    }

    public StoneBlockSet(class_2248 base_block) {
        this(base_block, SetGroup.TYPICAL);
    }

    public StoneBlockSet(class_2248 base_block, SetGroup group) {
        this(base_block, group.components);
    }

    public StoneBlockSet(class_2248 base_block, SetGroup group, SetComponent ... additionalParts) {
        this(base_block, StoneBlockSet.concatArray(group.components, additionalParts));
    }

    public StoneBlockSet(class_2248 base_block, SetComponent ... parts) {
        this.parts = new ArrayList<class_2248>();
        for (int i = 0; i < SetComponent.values().length; ++i) {
            this.parts.add(null);
        }
        this.material_name = StoneBlockSet.getMaterialFromBlock(class_2378.field_11146.method_10221((Object)base_block).method_12832());
        this.setPart(SetComponent.BLOCK, base_block);
        Arrays.stream(parts).forEachOrdered(this::createPart);
        instances.add(this);
        if (this.material_name.contains("ore_brick")) {
            RegistryUtil.oreBrickSets.add(this);
        } else {
            RegistryUtil.BlockSets.put(base_block, this);
        }
        if (this.getPart(SetComponent.NUB) != null) {
            RegistryUtil.nubs.put(this.getPart(SetComponent.NUB), List.of(this.get()));
        }
    }

    private static String getMaterialFromBlock(String blockName) {
        return blockName.replace("bricks", "brick").replace("_planks", "").replace("_block", "").replace("tiles", "tile").replace("boards", "board");
    }

    private static String getMaterialAggressive(String block) {
        return StoneBlockSet.getMaterialFromBlock(block).replace("_brick", "").replace("_tile", "").replace("chiseled_", "").replace("cut_", "");
    }

    private FabricBlockSettings properties() {
        return FabricBlockSettings.copyOf((class_4970)this.get());
    }

    @Override
    public class_2248 get() {
        return this.getPart(SetComponent.BLOCK);
    }

    private Stream<? extends class_2248> blockStream() {
        return this.parts.stream().filter(Objects::nonNull);
    }

    public void forEach(Consumer<? super class_2248> action) {
        this.blockStream().forEach(action);
    }

    public void forEachBlock(Consumer<class_2248> action) {
        this.blockStream().forEach(action);
    }

    public void forEachPart(BiConsumer<SetComponent, ? super class_2248> consumer) {
        for (int i = 0; i < this.parts.size(); ++i) {
            if (this.parts.get(i) == null) continue;
            consumer.accept(SetComponent.get(i), (class_2248)this.parts.get(i));
        }
    }

    public StoneBlockSet woodify() {
        this.usesAxe();
        this.hasStoneCuttingRecipes = false;
        return this;
    }

    public StoneBlockSet usesAxe() {
        this.miningTag = class_3481.field_33713;
        return this;
    }

    public StoneBlockSet needsStone() {
        this.miningLevel = class_3481.field_33719;
        return this;
    }

    public StoneBlockSet needsIron() {
        this.miningLevel = class_3481.field_33718;
        return this;
    }

    public StoneBlockSet needsDiamond() {
        this.miningLevel = class_3481.field_33717;
        return this;
    }

    public class_2248 getPart(SetComponent part) {
        return this.parts.get(part.ordinal());
    }

    private <B extends class_2248> void setPart(SetComponent part, B block) {
        this.parts.add(part.ordinal(), block);
    }

    private void createPart(SetComponent part) {
        this.setPart(part, this.makePart(part));
    }

    public void withPart(SetComponent part, Consumer<class_2248> action) {
        class_2248 block = this.getPart(part);
        if (block != null) {
            action.accept(block);
        }
    }

    private class_2248 makePart(SetComponent part) {
        class_2248 block = this.getPart(SetComponent.BLOCK);
        if (block instanceof IBlockSetBase) {
            IBlockSetBase base = (IBlockSetBase)block;
            return RegistryUtil.createBlock(part.getName(this.material_name), base.getBlockForPart(part, this.properties(), block));
        }
        return RegistryUtil.createBlock(part.getName(this.material_name), StoneBlockSet.getBlockForPart(part, this.properties(), block));
    }

    public static class_2248 getBlockForPart(SetComponent part, FabricBlockSettings settings, class_2248 base) {
        return switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case SetComponent.WALL -> new class_2544((class_4970.class_2251)settings);
            case SetComponent.SLAB -> new class_2482((class_4970.class_2251)settings);
            case SetComponent.VERTICAL_SLAB -> new VerticalSlabBlock((class_4970.class_2251)settings);
            case SetComponent.STAIRS -> new class_2510(base.method_9564(), (class_4970.class_2251)settings);
            case SetComponent.FENCE -> new class_2354((class_4970.class_2251)settings);
            case SetComponent.PILLAR -> new class_2465((class_4970.class_2251)settings);
            case SetComponent.NUB -> new NubBlock((class_4970.class_2251)settings);
            case SetComponent.BLOCK -> throw new IllegalStateException("Should not call createPart on BLOCK. Use setPart instead.");
        };
    }

    private static <T> T[] concatArray(T[] array1, T[] array2) {
        T[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static enum SetGroup {
        SLABS(SetComponent.SLAB, SetComponent.VERTICAL_SLAB),
        NO_WALLS(SetComponent.SLAB, SetComponent.VERTICAL_SLAB, SetComponent.STAIRS),
        NO_STAIRS(SetComponent.SLAB, SetComponent.VERTICAL_SLAB, SetComponent.WALL),
        TYPICAL(SetComponent.SLAB, SetComponent.VERTICAL_SLAB, SetComponent.STAIRS, SetComponent.WALL);

        public final SetComponent[] components;

        private SetGroup(SetComponent ... components) {
            this.components = components;
        }

        public void forEach(Consumer<SetComponent> action) {
            Arrays.stream(this.components).forEachOrdered(action);
        }
    }

    public static enum SetComponent {
        BLOCK("", class_1761.field_7931),
        SLAB("_slab", class_1761.field_7931),
        VERTICAL_SLAB("_vertical_slab", class_1761.field_7931),
        STAIRS("_stairs", class_1761.field_7931),
        WALL("_wall", class_1761.field_7928),
        FENCE("_fence", class_1761.field_7928),
        PILLAR(SetComponent::pillarName, class_1761.field_7931),
        NUB("_nub", class_1761.field_7928);

        public final class_1761 tab;
        public final Function<String, String> nameGenerator;
        private static final SetComponent[] values;

        private SetComponent(String suffix, class_1761 tab) {
            this((String material) -> SetComponent.addSuffix(material, suffix), tab);
        }

        private SetComponent(Function<String, String> nameGen, class_1761 tab) {
            this.nameGenerator = nameGen;
            this.tab = tab;
        }

        public String getName(String material) {
            return this.nameGenerator.apply(material);
        }

        private static String addSuffix(String material, String suffix) {
            return material + suffix;
        }

        private static String pillarName(String material) {
            return StoneBlockSet.getMaterialAggressive(material) + "_pillar";
        }

        public static SetComponent get(int ordinal) {
            return values[ordinal];
        }

        static {
            values = SetComponent.values();
        }
    }
}

