/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.common.compat.CompatHandler;
import artifacts.common.config.ModConfig;
import artifacts.common.init.ModFeatures;
import artifacts.common.init.ModItems;
import artifacts.common.init.ModLootConditions;
import artifacts.common.init.ModLootTables;
import artifacts.common.init.ModSoundEvents;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Artifacts
implements ModInitializer {
    public static final String MODID = "artifacts";
    public static final Logger LOGGER = LoggerFactory.getLogger(Artifacts.class);
    public static final class_1761 CREATIVE_TAB = FabricItemGroupBuilder.build((class_2960)Artifacts.id("item_group"), () -> new class_1799((class_1935)ModItems.BUNNY_HOPPERS));
    public static ModConfig CONFIG;
    public static final int CONFIG_VERSION = 1;

    public void onInitialize() {
        CONFIG = this.getConfigAndInvalidateOldVersions();
        ModLootConditions.register();
        LootTableEvents.MODIFY.register((rm, lt, id, supplier, s) -> ModLootTables.onLootTableLoad(id, supplier));
        ModItems.ANTIDOTE_VESSEL.toString();
        ModSoundEvents.MIMIC_CLOSE.toString();
        ModFeatures.register();
        this.runCompatibilityHandlers();
        LOGGER.info("Finished initialization");
    }

    private ModConfig getConfigAndInvalidateOldVersions() {
        ConfigHolder configHolder = AutoConfig.register(ModConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(Toml4jConfigSerializer::new));
        int currentVersion = ((ModConfig)configHolder.getConfig()).general.configVersion;
        int requiredVersion = 1;
        if (currentVersion != requiredVersion) {
            LOGGER.warn("Resetting incompatible config with version {} to version {}", (Object)currentVersion, (Object)requiredVersion);
            configHolder.resetToDefault();
            configHolder.save();
        }
        return (ModConfig)configHolder.getConfig();
    }

    private void runCompatibilityHandlers() {
        FabricLoader.getInstance().getEntrypoints("artifacts:compat_handlers", CompatHandler.class).stream().filter(h -> FabricLoader.getInstance().isModLoaded(h.getModId())).forEach(ch -> {
            String modName = FabricLoader.getInstance().getModContainer(ch.getModId()).map(c -> c.getMetadata().getName()).orElse(ch.getModId());
            LOGGER.info("Running compat handler for " + modName);
            ch.run();
        });
    }

    public static class_2960 id(String path) {
        return new class_2960(MODID, path);
    }
}

