/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.curio.renderer;

import artifacts.client.render.curio.model.ArmsModel;
import artifacts.common.trinkets.TrinketsHelper;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.client.TrinketRenderer;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_918;

public class GloveCurioRenderer
implements TrinketRenderer {
    private final class_2960 defaultTexture;
    private final class_2960 slimTexture;
    private final ArmsModel defaultModel;
    private final ArmsModel slimModel;

    public GloveCurioRenderer(String name, ArmsModel defaultModel, ArmsModel slimModel) {
        this(String.format("glove/%s/%s_default", name, name), String.format("glove/%s/%s_slim", name, name), defaultModel, slimModel);
    }

    public GloveCurioRenderer(String defaultTexturePath, String slimTexturePath, ArmsModel defaultModel, ArmsModel slimModel) {
        this.defaultTexture = new class_2960("artifacts", String.format("textures/entity/curio/%s.png", defaultTexturePath));
        this.slimTexture = new class_2960("artifacts", String.format("textures/entity/curio/%s.png", slimTexturePath));
        this.defaultModel = defaultModel;
        this.slimModel = slimModel;
    }

    protected class_2960 getTexture(boolean hasSlimArms) {
        return hasSlimArms ? this.slimTexture : this.defaultTexture;
    }

    protected ArmsModel getModel(boolean hasSlimArms) {
        return hasSlimArms ? this.slimModel : this.defaultModel;
    }

    protected static boolean hasSlimArms(class_1297 entity) {
        class_742 player;
        return entity instanceof class_742 && (player = (class_742)entity).method_3121().equals("slim");
    }

    public final void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> contextModel, class_4587 poseStack, class_4597 multiBufferSource, int light, class_1309 entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!TrinketsHelper.areCosmetisEnabled(stack)) {
            return;
        }
        boolean hasSlimArms = GloveCurioRenderer.hasSlimArms((class_1297)entity);
        ArmsModel model = this.getModel(hasSlimArms);
        String slotGroup = slotReference.inventory().getSlotType().getGroup();
        class_1306 handSide = slotGroup.equals("hand") ? entity.method_6068() : entity.method_6068().method_5928();
        model.method_17087(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.method_17086(entity, limbSwing, limbSwingAmount, partialTicks);
        TrinketRenderer.followBodyRotations((class_1309)entity, (class_572)model);
        this.renderArm(model, poseStack, multiBufferSource, handSide, light, hasSlimArms, stack.method_7958());
    }

    protected void renderArm(ArmsModel model, class_4587 matrixStack, class_4597 buffer, class_1306 handSide, int light, boolean hasSlimArms, boolean hasFoil) {
        class_1921 renderType = model.method_23500(this.getTexture(hasSlimArms));
        class_4588 vertexBuilder = class_918.method_23181((class_4597)buffer, (class_1921)renderType, (boolean)false, (boolean)hasFoil);
        model.renderArm(handSide, matrixStack, vertexBuilder, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public final void renderFirstPersonArm(class_4587 matrixStack, class_4597 buffer, int light, class_742 player, class_1306 side, boolean hasFoil) {
        if (!player.method_7325()) {
            boolean hasSlimArms = GloveCurioRenderer.hasSlimArms((class_1297)player);
            ArmsModel model = this.getModel(hasSlimArms);
            class_630 arm = side == class_1306.field_6182 ? model.field_27433 : model.field_3401;
            model.method_2805(false);
            arm.field_3665 = true;
            model.field_3400 = false;
            model.field_3396 = 0.0f;
            model.field_3447 = 0.0f;
            model.method_17087((class_1309)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            arm.field_3654 = 0.0f;
            this.renderFirstPersonArm(model, arm, matrixStack, buffer, light, hasSlimArms, hasFoil);
        }
    }

    protected void renderFirstPersonArm(ArmsModel model, class_630 arm, class_4587 matrixStack, class_4597 buffer, int light, boolean hasSlimArms, boolean hasFoil) {
        class_1921 renderType = model.method_23500(this.getTexture(hasSlimArms));
        class_4588 builder = class_918.method_23181((class_4597)buffer, (class_1921)renderType, (boolean)false, (boolean)hasFoil);
        arm.method_22698(matrixStack, builder, light, class_4608.field_21444);
    }
}

