/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.entity;

import artifacts.common.init.ModSoundEvents;
import java.util.EnumSet;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class MimicEntity
extends class_1308
implements class_1569 {
    public static final class_2960 MIMIC = new class_2960("artifacts", "entities/mimic");
    public int ticksInAir;
    public int attackCooldown;
    public boolean isDormant;
    public class_2350 facing;

    public MimicEntity(class_1299<? extends MimicEntity> type, class_1937 world) {
        super(type, world);
        this.field_6207 = new MimicMovementController(this);
        this.field_6194 = 10;
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23718, 0.8).method_26868(class_5134.field_23719, 0.8).method_26868(class_5134.field_23721, 5.0);
    }

    public void setFacing(class_2350 facing) {
        class_1335 class_13352;
        this.facing = facing;
        if (facing != null && (class_13352 = this.method_5962()) instanceof MimicMovementController) {
            MimicMovementController controller = (MimicMovementController)class_13352;
            controller.setDirection(facing.method_10144(), false);
        }
    }

    public void setDormant(boolean isDormant) {
        this.isDormant = isDormant;
        if (!isDormant) {
            this.facing = null;
        }
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public boolean method_5974(double distance) {
        return false;
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new FloatGoal(this));
        this.field_6201.method_6277(2, (class_1352)new AttackGoal(this));
        this.field_6201.method_6277(3, (class_1352)new FaceRandomGoal(this));
        this.field_6201.method_6277(5, (class_1352)new HopGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, 1, true, false, entity -> !this.isDormant || (double)this.method_5739((class_1297)entity) < this.method_5996(class_5134.field_23717).method_6194() / 2.5));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("ticksInAir", this.ticksInAir);
        compound.method_10556("isDormant", this.isDormant);
        if (this.facing != null) {
            compound.method_10582("facing", this.facing.name());
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.ticksInAir = compound.method_10550("ticksInAir");
        this.facing = compound.method_10573("facing", 8) ? class_2350.method_10168((String)compound.method_10558("facing")) : null;
        this.setDormant(compound.method_10577("isDormant"));
        this.setFacing(this.facing);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5799()) {
            this.ticksInAir = 0;
            if (this.isDormant) {
                this.setDormant(false);
            }
        } else if (!this.field_5952) {
            ++this.ticksInAir;
        } else if (this.ticksInAir > 0) {
            this.method_5783(this.getLandingSound(), this.method_6107(), this.method_6017());
            this.ticksInAir = 0;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public void method_5694(class_1657 player) {
        super.method_5694(player);
        if (this.attackCooldown <= 0 && player.method_5770().method_8407() != class_1267.field_5801 && this.method_5707(player.method_5829().method_1005().method_1023(0.0, this.method_5829().method_17940() / 2.0, 0.0)) < 1.0 && player.method_5643(class_1282.method_5511((class_1309)this), (float)this.method_5996(class_5134.field_23721).method_6194())) {
            this.attackCooldown = 20;
            this.method_5723((class_1309)this, (class_1297)player);
        }
    }

    public void method_5980(class_1309 entity) {
        this.setDormant(false);
        super.method_5980(entity);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1335 class_13352;
        if (source.method_5529() instanceof class_1657) {
            this.method_5980((class_1309)source.method_5529());
        }
        if (this.ticksInAir <= 0 && source.method_5533() && !source.method_5537()) {
            this.method_5783(ModSoundEvents.MIMIC_HURT, this.method_6107(), this.method_6017());
            return false;
        }
        if (this.method_24828() && this.method_6051().method_43056() && (class_13352 = this.method_5962()) instanceof MimicMovementController) {
            MimicMovementController controller = (MimicMovementController)class_13352;
            controller.setDirection(this.method_6051().method_43048(4) * 90, true);
        }
        return super.method_5643(source, amount);
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return ModSoundEvents.MIMIC_HURT;
    }

    protected class_3414 method_6002() {
        return ModSoundEvents.MIMIC_DEATH;
    }

    protected class_3414 getJumpingSound() {
        return ModSoundEvents.MIMIC_OPEN;
    }

    protected class_3414 getLandingSound() {
        return ModSoundEvents.MIMIC_CLOSE;
    }

    protected class_2960 method_5991() {
        return MIMIC;
    }

    protected static class MimicMovementController
    extends class_1335 {
        private final MimicEntity mimic;
        private float rotationDegrees;
        private int jumpDelay;

        public MimicMovementController(MimicEntity mimic) {
            super((class_1308)mimic);
            this.mimic = mimic;
            this.rotationDegrees = 180.0f * mimic.method_36454() / (float)Math.PI;
            this.jumpDelay = mimic.field_5974.method_43048(320) + 640;
        }

        public void setDirection(float rotation, boolean shouldJump) {
            this.rotationDegrees = rotation;
            if (shouldJump && this.jumpDelay > 10) {
                this.jumpDelay = 10;
            }
        }

        public void setSpeed(double speed) {
            this.field_6372 = speed;
            this.field_6374 = class_1335.class_1336.field_6378;
        }

        public void method_6240() {
            this.mimic.field_6241 = this.mimic.field_6283 = this.method_6238(this.mimic.method_36454(), this.rotationDegrees, 90.0f);
            this.mimic.method_36456(this.mimic.field_6241);
            if (this.field_6374 != class_1335.class_1336.field_6378) {
                this.mimic.method_5930(0.0f);
            } else {
                this.field_6374 = class_1335.class_1336.field_6377;
                if (this.mimic.field_5952) {
                    this.mimic.method_6125((float)(this.field_6372 * this.mimic.method_5996(class_5134.field_23719).method_6194()));
                    if (this.jumpDelay-- > 0) {
                        this.mimic.field_6250 = 0.0f;
                        this.mimic.field_6212 = 0.0f;
                        this.mimic.method_6125(0.0f);
                    } else {
                        this.jumpDelay = this.mimic.field_5974.method_43048(320) + 640;
                        this.mimic.field_6204.method_6233();
                        this.mimic.method_5783(this.mimic.getJumpingSound(), this.mimic.method_6107(), this.mimic.method_6017());
                    }
                } else {
                    this.mimic.method_6125((float)(this.field_6372 * this.mimic.method_5996(class_5134.field_23719).method_6194()));
                }
            }
        }
    }

    protected static class FloatGoal
    extends class_1352 {
        private final MimicEntity mimic;

        public FloatGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
            mimic.method_5942().method_6354(true);
        }

        public boolean method_6264() {
            return this.mimic.method_5799() || this.mimic.method_5771();
        }

        public void method_6268() {
            if (this.mimic.method_6051().method_43057() < 0.8f) {
                this.mimic.field_6204.method_6233();
            }
            if (this.mimic.method_5962() instanceof MimicMovementController) {
                ((MimicMovementController)this.mimic.method_5962()).setSpeed(1.2);
            }
        }
    }

    protected static class AttackGoal
    extends class_1352 {
        private final MimicEntity mimic;
        private int timeRemaining;

        public AttackGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.mimic.method_5968();
            return target instanceof class_1657 && target.method_5805() && target.method_5770().method_8407() != class_1267.field_5801 && !((class_1657)target).method_31549().field_7480;
        }

        public void method_6269() {
            this.timeRemaining = 300;
            super.method_6269();
        }

        public boolean method_6266() {
            class_1309 target = this.mimic.method_5968();
            return target instanceof class_1657 && target.method_5805() && target.method_5770().method_8407() != class_1267.field_5801 && !((class_1657)target).method_31549().field_7480 && --this.timeRemaining > 0;
        }

        public void method_6268() {
            class_1335 class_13352;
            super.method_6268();
            if (this.mimic.isDormant) {
                return;
            }
            if (this.mimic.method_5968() != null && (class_13352 = this.mimic.method_5962()) instanceof MimicMovementController) {
                MimicMovementController controller = (MimicMovementController)class_13352;
                this.mimic.method_5951((class_1297)this.mimic.method_5968(), 10.0f, 10.0f);
                controller.setDirection(this.mimic.method_36454(), true);
            }
        }
    }

    protected static class FaceRandomGoal
    extends class_1352 {
        private final MimicEntity mimic;
        private int chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.mimic.method_5968() == null && (this.mimic.field_5952 || this.mimic.method_5799() || this.mimic.method_5771() || this.mimic.method_6059(class_1294.field_5902));
        }

        public void method_6268() {
            class_1335 class_13352;
            if (this.mimic.isDormant) {
                return;
            }
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 480 + this.mimic.method_6051().method_43048(320);
                this.chosenDegrees = this.mimic.method_6051().method_43048(4) * 90;
            }
            if ((class_13352 = this.mimic.method_5962()) instanceof MimicMovementController) {
                MimicMovementController controller = (MimicMovementController)class_13352;
                controller.setDirection(this.chosenDegrees, false);
            }
        }
    }

    protected static class HopGoal
    extends class_1352 {
        private final MimicEntity mimic;

        public HopGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return !this.mimic.isDormant && !this.mimic.method_5765();
        }

        public void method_6268() {
            if (this.mimic.method_5962() instanceof MimicMovementController) {
                ((MimicMovementController)this.mimic.method_5962()).setSpeed(1.0);
            }
        }
    }
}

