/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.util;

import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.util.UUIDTypeAdapter;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import me.axieum.mcmod.authme.api.util.SessionUtils;
import me.axieum.mcmod.authme.impl.AuthMe;
import net.minecraft.class_320;

public final class MojangUtils {
    private MojangUtils() {
    }

    public static CompletableFuture<class_320> login(String username, String password, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            AuthMe.LOGGER.info("Logging into Minecraft with Mojang (or legacy) credentials...");
            try {
                YggdrasilUserAuthentication yua = SessionUtils.getAuthProvider();
                yua.setUsername(username);
                yua.setPassword(password);
                yua.logIn();
                String name = yua.getSelectedProfile().getName();
                String uuid = UUIDTypeAdapter.fromUUID((UUID)yua.getSelectedProfile().getId());
                String token = yua.getAuthenticatedToken();
                class_320.class_321 type = class_320.class_321.method_1679((String)yua.getUserType().getName());
                yua.logOut();
                AuthMe.LOGGER.info("Successfully logged into Minecraft via Mojang (or legacy)! ({})", (Object)name);
                return new class_320(name, uuid, token, Optional.empty(), Optional.empty(), type);
            }
            catch (Exception e) {
                AuthMe.LOGGER.error("Unable to login to Minecraft via Mojang (or legacy)!", (Throwable)e);
                throw new CompletionException(e);
            }
        }, executor);
    }
}

