/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.util;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.axieum.mcmod.authme.impl.AuthMe;
import me.axieum.mcmod.authme.mixin.MinecraftClientAccessor;
import me.axieum.mcmod.authme.mixin.RealmsMainScreenAccessor;
import me.axieum.mcmod.authme.mixin.SplashTextResourceSupplierAccessor;
import me.axieum.mcmod.authme.mixin.YggdrasilAuthenticationServiceAccessor;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_5520;
import net.minecraft.class_7434;
import net.minecraft.class_7569;
import net.minecraft.class_7574;

public final class SessionUtils {
    public static final String OFFLINE_TOKEN = "invalidtoken";
    public static final long STATUS_TTL = 60000L;
    private static long lastStatusCheck;
    private static SessionStatus lastStatus;

    private SessionUtils() {
    }

    public static class_320 getSession() {
        return class_310.method_1551().method_1548();
    }

    public static void setSession(class_320 session) {
        class_310 client = class_310.method_1551();
        ((MinecraftClientAccessor)client).setSession(session);
        ((SplashTextResourceSupplierAccessor)client.method_18095()).setSession(session);
        client.method_1539().clear();
        client.method_1539();
        UserApiService userApiService = UserApiService.OFFLINE;
        if (!OFFLINE_TOKEN.equals(session.method_1674())) {
            try {
                userApiService = SessionUtils.getAuthService().createUserApiService(session.method_1674());
            }
            catch (AuthenticationException e) {
                AuthMe.LOGGER.error("Failed to verify authentication for new user API service!", (Throwable)e);
            }
        }
        ((MinecraftClientAccessor)client).setUserApiService(userApiService);
        ((MinecraftClientAccessor)client).setSocialInteractionsManager(new class_5520(client, userApiService));
        ((MinecraftClientAccessor)client).setProfileKeys(new class_7434(userApiService, session.method_1677().getId(), client.field_1697.toPath()));
        ((MinecraftClientAccessor)client).setAbuseReportContext(class_7574.method_44599((class_7569)client.method_44377().comp_886(), (UserApiService)userApiService));
        RealmsMainScreenAccessor.setCheckedClientCompatibility(false);
        RealmsMainScreenAccessor.setRealmsGenericErrorScreen(null);
        lastStatus = SessionStatus.UNKNOWN;
        lastStatusCheck = 0L;
        AuthMe.LOGGER.info("Minecraft session for {} (uuid={}) has been applied", (Object)session.method_1676(), (Object)session.method_1673());
    }

    public static class_320 offline(String username) {
        return new class_320(username, UUID.nameUUIDFromBytes(("offline:" + username).getBytes()).toString(), OFFLINE_TOKEN, Optional.empty(), Optional.empty(), class_320.class_321.field_1990);
    }

    public static CompletableFuture<SessionStatus> getStatus() {
        if (System.currentTimeMillis() - lastStatusCheck < 60000L) {
            return CompletableFuture.completedFuture(lastStatus);
        }
        return CompletableFuture.supplyAsync(() -> {
            class_320 session = SessionUtils.getSession();
            GameProfile profile = session.method_1677();
            String token = session.method_1674();
            String id = UUID.randomUUID().toString();
            YggdrasilMinecraftSessionService sessionService = SessionUtils.getSessionService();
            try {
                AuthMe.LOGGER.info("Verifying Minecraft session...");
                sessionService.joinServer(profile, token, id);
                if (sessionService.hasJoinedServer(profile, id, null).isComplete()) {
                    AuthMe.LOGGER.info("The Minecraft session is valid");
                    lastStatus = SessionStatus.VALID;
                } else {
                    AuthMe.LOGGER.warn("The Minecraft session is invalid!");
                    lastStatus = SessionStatus.INVALID;
                }
            }
            catch (AuthenticationException e) {
                AuthMe.LOGGER.error("Could not validate the Minecraft session!", (Throwable)e);
                lastStatus = SessionStatus.OFFLINE;
            }
            lastStatusCheck = System.currentTimeMillis();
            return lastStatus;
        });
    }

    public static YggdrasilMinecraftSessionService getSessionService() {
        return (YggdrasilMinecraftSessionService)class_310.method_1551().method_1495();
    }

    public static YggdrasilAuthenticationService getAuthService() {
        YggdrasilAuthenticationService authService = SessionUtils.getSessionService().getAuthenticationService();
        if (((YggdrasilAuthenticationServiceAccessor)authService).getClientToken() == null) {
            ((YggdrasilAuthenticationServiceAccessor)authService).setClientToken(UUID.randomUUID().toString());
        }
        return authService;
    }

    public static YggdrasilUserAuthentication getAuthProvider() {
        return (YggdrasilUserAuthentication)SessionUtils.getAuthService().createUserAuthentication(Agent.MINECRAFT);
    }

    static {
        lastStatus = SessionStatus.UNKNOWN;
    }

    public static enum SessionStatus {
        VALID,
        INVALID,
        OFFLINE,
        UNKNOWN;

    }
}

