/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.network.BalmNetworking;
import net.blay09.mods.balm.api.network.ClientboundMessageRegistration;
import net.blay09.mods.balm.api.network.MessageRegistration;
import net.blay09.mods.balm.api.network.ServerboundMessageRegistration;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FabricBalmNetworking
implements BalmNetworking {
    private static final Map<Class<?>, MessageRegistration<?>> messagesByClass = new HashMap();
    private static final Map<class_2960, MessageRegistration<?>> messagesByIdentifier = new HashMap();
    private static final List<ClientboundMessageRegistration<?>> clientMessageRegistrations = new ArrayList();
    private static class_1657 replyPlayer;

    @Override
    public void allowClientOnly(String modId) {
    }

    @Override
    public void allowServerOnly(String modId) {
    }

    @Override
    public void openGui(class_1657 player, class_3908 menuProvider) {
        if (menuProvider instanceof BalmMenuProvider) {
            final BalmMenuProvider balmMenuProvider = (BalmMenuProvider)menuProvider;
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                    balmMenuProvider.writeScreenOpeningData(player, buf);
                }

                public class_2561 method_5476() {
                    return balmMenuProvider.method_5476();
                }

                @Nullable
                public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    return balmMenuProvider.createMenu(i, inventory, player);
                }
            });
        } else {
            player.method_17355(menuProvider);
        }
    }

    @Override
    public <T> void reply(T message) {
        if (replyPlayer == null) {
            throw new IllegalStateException("No player to reply to");
        }
        this.sendTo(replyPlayer, message);
    }

    @Override
    public <T> void sendTo(class_1657 player, T message) {
        MessageRegistration<?> messageRegistration = messagesByClass.get(message.getClass());
        class_2960 identifier = messageRegistration.getIdentifier();
        class_2540 buf = PacketByteBufs.create();
        messageRegistration.getEncodeFunc().accept(message, buf);
        ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)identifier, (class_2540)buf);
    }

    @Override
    public <T> void sendToTracking(class_3218 world, class_2338 pos, T message) {
        MessageRegistration<?> messageRegistration = messagesByClass.get(message.getClass());
        class_2960 identifier = messageRegistration.getIdentifier();
        class_2540 buf = PacketByteBufs.create();
        messageRegistration.getEncodeFunc().accept(message, buf);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)pos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)identifier, (class_2540)buf);
        }
    }

    @Override
    public <T> void sendToTracking(class_1297 entity, T message) {
        MessageRegistration<?> messageRegistration = messagesByClass.get(message.getClass());
        class_2960 identifier = messageRegistration.getIdentifier();
        class_2540 buf = PacketByteBufs.create();
        messageRegistration.getEncodeFunc().accept(message, buf);
        for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)identifier, (class_2540)buf);
        }
    }

    @Override
    public <T> void sendToAll(MinecraftServer server, T message) {
        MessageRegistration<?> messageRegistration = messagesByClass.get(message.getClass());
        class_2960 identifier = messageRegistration.getIdentifier();
        class_2540 buf = PacketByteBufs.create();
        messageRegistration.getEncodeFunc().accept(message, buf);
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)identifier, (class_2540)buf);
        }
    }

    @Override
    public <T> void sendToServer(T message) {
        MessageRegistration<?> messageRegistration = messagesByClass.get(message.getClass());
        class_2960 identifier = messageRegistration.getIdentifier();
        class_2540 buf = PacketByteBufs.create();
        messageRegistration.getEncodeFunc().accept(message, buf);
        ClientPlayNetworking.send((class_2960)identifier, (class_2540)buf);
    }

    @Override
    public <T> void registerClientboundPacket(class_2960 identifier, Class<T> clazz, BiConsumer<T, class_2540> encodeFunc, Function<class_2540, T> decodeFunc, BiConsumer<class_1657, T> handler) {
        ClientboundMessageRegistration<T> messageRegistration = new ClientboundMessageRegistration<T>(identifier, clazz, encodeFunc, decodeFunc, handler);
        messagesByClass.put(clazz, messageRegistration);
        messagesByIdentifier.put(identifier, messageRegistration);
        clientMessageRegistrations.add(messageRegistration);
    }

    @Override
    public <T> void registerServerboundPacket(class_2960 identifier, Class<T> clazz, BiConsumer<T, class_2540> encodeFunc, Function<class_2540, T> decodeFunc, BiConsumer<class_3222, T> handler) {
        ServerboundMessageRegistration messageRegistration = new ServerboundMessageRegistration(identifier, clazz, encodeFunc, decodeFunc, handler);
        messagesByClass.put(clazz, messageRegistration);
        messagesByIdentifier.put(identifier, messageRegistration);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)identifier, (server, player, listener, buf, responseSender) -> {
            Object message = messageRegistration.getDecodeFunc().apply(buf);
            server.execute(() -> {
                replyPlayer = player;
                handler.accept(player, message);
                replyPlayer = null;
            });
        });
    }

    public static void initializeClientHandlers() {
        for (ClientboundMessageRegistration<?> message : clientMessageRegistrations) {
            FabricBalmNetworking.registerClientHandler(message);
        }
    }

    private static <T> void registerClientHandler(ClientboundMessageRegistration<T> messageRegistration) {
        class_2960 identifier = messageRegistration.getIdentifier();
        BiConsumer handler = messageRegistration.getHandler();
        ClientPlayNetworking.registerGlobalReceiver((class_2960)identifier, (client, listener, buf, responseSender) -> {
            Object message = messageRegistration.getDecodeFunc().apply(buf);
            client.execute(() -> handler.accept(BalmClient.getClientPlayer(), message));
        });
    }
}

