/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.beenfo.config;

import de.guntram.mcmod.fabrictools.ConfigChangedEvent;
import de.guntram.mcmod.fabrictools.Configuration;
import de.guntram.mcmod.fabrictools.ModConfigurationHandler;
import java.io.File;

public class ConfigurationHandler
implements ModConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private String configFileName;
    private boolean showPopup;
    private int popupXPercent;
    private int popupYPercent;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("Beenfo")) {
            this.loadConfig();
        }
    }

    public void onConfigChanging(ConfigChangedEvent.OnConfigChangingEvent event) {
        if (event.getModID().equals("Beenfo")) {
            switch (event.getItem()) {
                case "beenfo.config.showpopup": {
                    this.showPopup = (Boolean)event.getNewValue();
                    break;
                }
                case "beenfo.config.popupxpercent": {
                    this.popupXPercent = (Integer)event.getNewValue();
                    break;
                }
                case "beenfo.config.popupypercent": {
                    this.popupYPercent = (Integer)event.getNewValue();
                }
            }
        }
    }

    private void loadConfig() {
        this.showPopup = this.config.getBoolean("beenfo.config.showpopup", 0, false, "beenfo.config.tt.showpopup");
        this.popupXPercent = this.config.getInt("beenfo.config.popupxpercent", 0, 50, 0, 100, "beenfo.config.tt.popupxpercent");
        this.popupYPercent = this.config.getInt("beenfo.config.popupypercent", 0, 50, 0, 100, "beenfo.config.tt.popupypercent");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration getConfig() {
        return ConfigurationHandler.getInstance().config;
    }

    public static boolean getShowPopup() {
        return ConfigurationHandler.getInstance().showPopup;
    }

    public static int getXPercent() {
        return ConfigurationHandler.getInstance().popupXPercent;
    }

    public static int getYPercent() {
        return ConfigurationHandler.getInstance().popupYPercent;
    }
}

