/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client.collision;

import net.minecraft.class_1160;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4581;

public class OrientedBoundingBox {
    public class_243 center;
    public class_243 extent;
    public class_243 axisX;
    public class_243 axisY;
    public class_243 axisZ;
    public class_243 scaledAxisX;
    public class_243 scaledAxisY;
    public class_243 scaledAxisZ;
    public class_4581 rotation = new class_4581();
    public class_243 vertex1;
    public class_243 vertex2;
    public class_243 vertex3;
    public class_243 vertex4;
    public class_243 vertex5;
    public class_243 vertex6;
    public class_243 vertex7;
    public class_243 vertex8;
    public class_243[] vertices;

    public OrientedBoundingBox(class_243 center, double width, double height, double depth, float yaw, float pitch) {
        this.center = center;
        this.extent = new class_243(width / 2.0, height / 2.0, depth / 2.0);
        this.axisZ = class_243.method_1030((float)yaw, (float)pitch).method_1029();
        this.axisY = class_243.method_1030((float)(yaw + 90.0f), (float)pitch).method_22882().method_1029();
        this.axisX = this.axisZ.method_1036(this.axisY);
    }

    public OrientedBoundingBox(class_243 center, class_243 size, float yaw, float pitch) {
        this(center, size.field_1352, size.field_1351, size.field_1350, yaw, pitch);
    }

    public OrientedBoundingBox(class_238 box) {
        this.center = new class_243((box.field_1320 + box.field_1323) / 2.0, (box.field_1325 + box.field_1322) / 2.0, (box.field_1324 + box.field_1321) / 2.0);
        this.extent = new class_243(Math.abs(box.field_1320 - box.field_1323) / 2.0, Math.abs(box.field_1325 - box.field_1322) / 2.0, Math.abs(box.field_1324 - box.field_1321) / 2.0);
        this.axisX = new class_243(1.0, 0.0, 0.0);
        this.axisY = new class_243(0.0, 1.0, 0.0);
        this.axisZ = new class_243(0.0, 0.0, 1.0);
    }

    public OrientedBoundingBox(OrientedBoundingBox obb) {
        this.center = obb.center;
        this.extent = obb.extent;
        this.axisX = obb.axisX;
        this.axisY = obb.axisY;
        this.axisZ = obb.axisZ;
    }

    public OrientedBoundingBox copy() {
        return new OrientedBoundingBox(this);
    }

    public OrientedBoundingBox offsetAlongAxisX(double offset) {
        this.center = this.center.method_1019(this.axisX.method_1021(offset));
        return this;
    }

    public OrientedBoundingBox offsetAlongAxisY(double offset) {
        this.center = this.center.method_1019(this.axisY.method_1021(offset));
        return this;
    }

    public OrientedBoundingBox offsetAlongAxisZ(double offset) {
        this.center = this.center.method_1019(this.axisZ.method_1021(offset));
        return this;
    }

    public OrientedBoundingBox offset(class_243 offset) {
        this.center = this.center.method_1019(offset);
        return this;
    }

    public OrientedBoundingBox scale(double scale) {
        this.extent = this.extent.method_1021(scale);
        return this;
    }

    public OrientedBoundingBox updateVertex() {
        this.rotation.method_26288(0, 0, (float)this.axisX.field_1352);
        this.rotation.method_26288(0, 1, (float)this.axisX.field_1351);
        this.rotation.method_26288(0, 2, (float)this.axisX.field_1350);
        this.rotation.method_26288(1, 0, (float)this.axisY.field_1352);
        this.rotation.method_26288(1, 1, (float)this.axisY.field_1351);
        this.rotation.method_26288(1, 2, (float)this.axisY.field_1350);
        this.rotation.method_26288(2, 0, (float)this.axisZ.field_1352);
        this.rotation.method_26288(2, 1, (float)this.axisZ.field_1351);
        this.rotation.method_26288(2, 2, (float)this.axisZ.field_1350);
        this.scaledAxisX = this.axisX.method_1021(this.extent.field_1352);
        this.scaledAxisY = this.axisY.method_1021(this.extent.field_1351);
        this.scaledAxisZ = this.axisZ.method_1021(this.extent.field_1350);
        this.vertex1 = this.center.method_1020(this.scaledAxisZ).method_1020(this.scaledAxisX).method_1020(this.scaledAxisY);
        this.vertex2 = this.center.method_1020(this.scaledAxisZ).method_1019(this.scaledAxisX).method_1020(this.scaledAxisY);
        this.vertex3 = this.center.method_1020(this.scaledAxisZ).method_1019(this.scaledAxisX).method_1019(this.scaledAxisY);
        this.vertex4 = this.center.method_1020(this.scaledAxisZ).method_1020(this.scaledAxisX).method_1019(this.scaledAxisY);
        this.vertex5 = this.center.method_1019(this.scaledAxisZ).method_1020(this.scaledAxisX).method_1020(this.scaledAxisY);
        this.vertex6 = this.center.method_1019(this.scaledAxisZ).method_1019(this.scaledAxisX).method_1020(this.scaledAxisY);
        this.vertex7 = this.center.method_1019(this.scaledAxisZ).method_1019(this.scaledAxisX).method_1019(this.scaledAxisY);
        this.vertex8 = this.center.method_1019(this.scaledAxisZ).method_1020(this.scaledAxisX).method_1019(this.scaledAxisY);
        this.vertices = new class_243[]{this.vertex1, this.vertex2, this.vertex3, this.vertex4, this.vertex5, this.vertex6, this.vertex7, this.vertex8};
        return this;
    }

    public boolean contains(class_243 point) {
        class_1160 distance = new class_1160(point.method_1020(this.center));
        distance.method_23215(this.rotation);
        return (double)Math.abs(distance.method_4943()) < this.extent.field_1352 && (double)Math.abs(distance.method_4945()) < this.extent.field_1351 && (double)Math.abs(distance.method_4947()) < this.extent.field_1350;
    }

    public boolean intersects(class_238 boundingBox) {
        OrientedBoundingBox otherOBB = new OrientedBoundingBox(boundingBox).updateVertex();
        return OrientedBoundingBox.Intersects(this, otherOBB);
    }

    public boolean intersects(OrientedBoundingBox otherOBB) {
        return OrientedBoundingBox.Intersects(this, otherOBB);
    }

    public static boolean Intersects(OrientedBoundingBox a, OrientedBoundingBox b) {
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisX)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisY)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisZ)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, b.scaledAxisX)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, b.scaledAxisY)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, b.scaledAxisZ)) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisX.method_1036(b.scaledAxisX))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisX.method_1036(b.scaledAxisY))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisX.method_1036(b.scaledAxisZ))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisY.method_1036(b.scaledAxisX))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisY.method_1036(b.scaledAxisY))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisY.method_1036(b.scaledAxisZ))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisZ.method_1036(b.scaledAxisX))) {
            return false;
        }
        if (OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisZ.method_1036(b.scaledAxisY))) {
            return false;
        }
        return !OrientedBoundingBox.Separated(a.vertices, b.vertices, a.scaledAxisZ.method_1036(b.scaledAxisZ));
    }

    private static boolean Separated(class_243[] vertsA, class_243[] vertsB, class_243 axis) {
        double sumSpan;
        if (axis.equals((Object)class_243.field_1353)) {
            return false;
        }
        double aMin = Double.POSITIVE_INFINITY;
        double aMax = Double.NEGATIVE_INFINITY;
        double bMin = Double.POSITIVE_INFINITY;
        double bMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 8; ++i) {
            double aDist = vertsA[i].method_1026(axis);
            aMin = aDist < aMin ? aDist : aMin;
            aMax = aDist > aMax ? aDist : aMax;
            double bDist = vertsB[i].method_1026(axis);
            bMin = bDist < bMin ? bDist : bMin;
            bMax = bDist > bMax ? bDist : bMax;
        }
        double longSpan = Math.max(aMax, bMax) - Math.min(aMin, bMin);
        return longSpan >= (sumSpan = aMax - aMin + bMax - bMin);
    }
}

