/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.panel.network;

import io.github.thecsdev.betterstats.client.gui.panel.BSPanel;
import io.github.thecsdev.betterstats.client.gui.screen.BetterStatsScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TOcpeRendererElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPlayerBadgePanel;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_2561;

public class BSNetworkProfilePanel
extends BSPanel {
    protected TOcpeRendererElement playerRenderer;
    protected TPlayerBadgePanel badgeShowcase;
    protected final boolean showPlayerBadges;

    public BSNetworkProfilePanel(int x, int y, int width, boolean showPlayerBadges) {
        super(x, y, width, 64 + (showPlayerBadges ? 64 : 0));
        this.showPlayerBadges = showPlayerBadges;
        this.setScrollPadding(7);
        this.setOutlineColor(0);
    }

    public final void init(BetterStatsScreen bss) {
        this.clearTChildren();
        this.onInit(bss);
    }

    protected void onInit(BetterStatsScreen bss) {
        int pad = this.getScrollPadding();
        int _13 = (int)((double)this.getTpeWidth() * 0.2);
        int wm13 = this.getTpeWidth() - _13;
        int ylw = Color.YELLOW.getRGB();
        String name = Objects.toString(bss.getBSStatHandler().gameProfile.getName(), "-");
        String uuid = Objects.toString(bss.getBSStatHandler().gameProfile.getId(), "-");
        this.playerRenderer = new TOcpeRendererElement(pad, pad, (int)((double)_13 * 0.8), this.getTpeHeight());
        this.playerRenderer.setProfileGP(bss.getBSStatHandler().gameProfile);
        this.playerRenderer.setScale(this.showPlayerBadges ? 1.8 : 1.0);
        this.addTChild((TElement)this.playerRenderer, true);
        TLabelElement lbl_nameKey = new TLabelElement(_13, pad, wm13, 10, (class_2561)TextUtils.translatable((String)"entity.minecraft.player", (Object[])new Object[0]));
        lbl_nameKey.setColor(ylw, ylw);
        this.addTChild((TElement)lbl_nameKey, true);
        TLabelElement lbl_nameVal = new TLabelElement(_13, pad + 10, wm13, 10, (class_2561)TextUtils.literal((String)name));
        this.addTChild((TElement)lbl_nameVal, true);
        TLabelElement lbl_uuidKey = new TLabelElement(_13, pad + 30, wm13, 10, (class_2561)TextUtils.literal((String)"UUID"));
        lbl_uuidKey.setColor(ylw, ylw);
        this.addTChild((TElement)lbl_uuidKey, true);
        TLabelElement lbl_uuidVal = new TLabelElement(_13, pad + 40, wm13, 10, (class_2561)TextUtils.literal((String)uuid));
        this.addTChild((TElement)lbl_uuidVal, true);
        if (this.showPlayerBadges) {
            TLabelElement lbl_badges = new TLabelElement(_13, pad + 60, wm13, 10, (class_2561)TextUtils.translatable((String)"betterstats.gui.network.badges", (Object[])new Object[0]));
            lbl_badges.setColor(ylw, ylw);
            this.addTChild((TElement)lbl_badges, true);
            this.badgeShowcase = new TPlayerBadgePanel(_13, pad + 74, wm13, 40, false);
            this.addTChild((TElement)this.badgeShowcase, true);
            this.badgeShowcase.init(bss.getBSStatHandler().collectPlayerBadges());
        }
    }
}

